/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.api.internal.artifacts.verification.signatures.CrossBuildCachingKeyService;
import org.gradle.api.internal.artifacts.verification.signatures.PublicKeySerializer;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationResultBuilder;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InterningStringSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class CrossBuildSignatureVerificationService
implements SignatureVerificationService {
    private final SignatureVerificationService delegate;
    private final FileHasher fileHasher;
    private final BuildCommencedTimeProvider timeProvider;
    private final boolean refreshKeys;
    private final PersistentCache store;
    private final PersistentIndexedCache<CacheKey, CacheEntry> cache;

    public CrossBuildSignatureVerificationService(SignatureVerificationService delegate, FileHasher fileHasher, CacheScopeMapping cacheScopeMapping, ProjectCacheDir projectCacheDir, CacheRepository repository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, BuildCommencedTimeProvider timeProvider, boolean refreshKeys) {
        this.delegate = delegate;
        this.fileHasher = fileHasher;
        this.timeProvider = timeProvider;
        this.refreshKeys = refreshKeys;
        File cacheDir = cacheScopeMapping.getBaseDirectory((Object)projectCacheDir.getDir(), "signature-verification", VersionStrategy.CachePerVersion);
        this.store = repository.cache(cacheDir).withDisplayName("Signature verification cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        InterningStringSerializer stringSerializer = new InterningStringSerializer(new StringInterner());
        this.cache = this.store.createCache(PersistentIndexedCacheParameters.of((String)"signature-verification", (Serializer)new CacheKeySerializer(stringSerializer, new SetSerializer((Serializer)stringSerializer)), (Serializer)new CacheEntrySerializer(stringSerializer)).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(500, true)));
    }

    @Override
    public void verify(File origin, File signature, Set<String> trustedKeys, Set<String> ignoredKeys, SignatureVerificationResultBuilder builder) {
        CacheKey cacheKey = new CacheKey(origin.getAbsolutePath(), signature.getAbsolutePath(), trustedKeys, ignoredKeys);
        HashCode originHash = this.fileHasher.hash(origin);
        HashCode signatureHash = this.fileHasher.hash(signature);
        CacheEntry entry = (CacheEntry)this.cache.getIfPresent((Object)cacheKey);
        if (entry == null || entry.updated(originHash, signatureHash) || this.hasExpired(entry)) {
            entry = this.performActualVerification(origin, signature, trustedKeys, ignoredKeys, originHash, signatureHash);
            this.cache.put((Object)cacheKey, (Object)entry);
        }
        entry.applyTo(builder);
    }

    private boolean hasExpired(CacheEntry entry) {
        List missingKeys = entry.missingKeys;
        if (missingKeys == null || missingKeys.isEmpty()) {
            return false;
        }
        long elapsed = entry.timestamp - this.timeProvider.getCurrentTime();
        return this.refreshKeys || elapsed > CrossBuildCachingKeyService.MISSING_KEY_TIMEOUT;
    }

    @Override
    public PublicKeyService getPublicKeyService() {
        return this.delegate.getPublicKeyService();
    }

    private CacheEntry performActualVerification(File origin, File signature, Set<String> trustedKeys, Set<String> ignoredKeys, HashCode originHash, HashCode signatureHash) {
        CacheEntryBuilder result = new CacheEntryBuilder(this.timeProvider.getCurrentTime(), originHash, signatureHash);
        this.delegate.verify(origin, signature, trustedKeys, ignoredKeys, result);
        return result.build();
    }

    public void stop() {
        this.delegate.stop();
        this.store.close();
    }

    private static class CacheEntrySerializer
    extends AbstractSerializer<CacheEntry> {
        private final InterningStringSerializer stringSerializer;
        private final PublicKeySerializer publicKeySerializer = new PublicKeySerializer();

        private CacheEntrySerializer(InterningStringSerializer stringSerializer) {
            this.stringSerializer = stringSerializer;
        }

        public CacheEntry read(Decoder decoder) throws Exception {
            long timestamp = decoder.readLong();
            HashCode originHash = HashCode.fromBytes((byte[])decoder.readBinary());
            HashCode signatureHash = HashCode.fromBytes((byte[])decoder.readBinary());
            List<String> missingKeys = this.readStringKeys(decoder);
            List<PGPPublicKey> trustedKeys = this.readKeys(decoder);
            List<PGPPublicKey> validKeys = this.readKeys(decoder);
            List<PGPPublicKey> failedKeys = this.readKeys(decoder);
            List<String> ignoredKeys = this.readStringKeys(decoder);
            return new CacheEntry(timestamp, originHash, signatureHash, missingKeys, trustedKeys, validKeys, failedKeys, ignoredKeys);
        }

        private List<String> readStringKeys(Decoder decoder) throws Exception {
            int missingKeysLen = decoder.readSmallInt();
            ArrayList missingKeys = null;
            if (missingKeysLen > 0) {
                missingKeys = Lists.newArrayListWithCapacity((int)missingKeysLen);
                for (int i = 0; i < missingKeysLen; ++i) {
                    missingKeys.add(this.stringSerializer.read(decoder));
                }
            }
            return missingKeys;
        }

        private List<PGPPublicKey> readKeys(Decoder decoder) throws Exception {
            int len = decoder.readSmallInt();
            ArrayList keys = null;
            if (len > 0) {
                keys = Lists.newArrayListWithCapacity((int)len);
                for (int i = 0; i < len; ++i) {
                    keys.add(this.publicKeySerializer.read(decoder));
                }
            }
            return keys;
        }

        public void write(Encoder encoder, CacheEntry value) throws Exception {
            encoder.writeLong(value.timestamp);
            encoder.writeBinary(value.originHash.toByteArray());
            encoder.writeBinary(value.signatureHash.toByteArray());
            this.writeStringKeys(encoder, value.missingKeys);
            this.writeKeys(encoder, value.trustedKeys);
            this.writeKeys(encoder, value.validKeys);
            this.writeKeys(encoder, value.failedKeys);
            this.writeStringKeys(encoder, value.ignoredKeys);
        }

        private void writeStringKeys(Encoder encoder, List<String> keys) throws Exception {
            if (keys == null) {
                encoder.writeSmallInt(0);
            } else {
                encoder.writeSmallInt(keys.size());
                for (String key : keys) {
                    this.stringSerializer.write(encoder, key);
                }
            }
        }

        private void writeKeys(Encoder encoder, List<PGPPublicKey> keys) throws Exception {
            if (keys == null) {
                encoder.writeSmallInt(0);
            } else {
                encoder.writeSmallInt(keys.size());
                for (PGPPublicKey key : keys) {
                    this.publicKeySerializer.write(encoder, key);
                }
            }
        }
    }

    private static class CacheEntry {
        private final long timestamp;
        private final HashCode originHash;
        private final HashCode signatureHash;
        private final List<String> missingKeys;
        private final List<PGPPublicKey> trustedKeys;
        private final List<PGPPublicKey> validKeys;
        private final List<PGPPublicKey> failedKeys;
        private final List<String> ignoredKeys;

        public CacheEntry(long timestamp, HashCode originHash, HashCode signatureHash, List<String> missingKeys, List<PGPPublicKey> trustedKeys, List<PGPPublicKey> validKeys, List<PGPPublicKey> failedKeys, List<String> ignoredKeys) {
            this.timestamp = timestamp;
            this.originHash = originHash;
            this.signatureHash = signatureHash;
            this.missingKeys = missingKeys;
            this.trustedKeys = trustedKeys;
            this.validKeys = validKeys;
            this.failedKeys = failedKeys;
            this.ignoredKeys = ignoredKeys;
        }

        void applyTo(SignatureVerificationResultBuilder builder) {
            if (this.missingKeys != null) {
                for (String missingKey : this.missingKeys) {
                    builder.missingKey(missingKey);
                }
            }
            if (this.trustedKeys != null) {
                for (PGPPublicKey trustedKey : this.trustedKeys) {
                    builder.verified(trustedKey, true);
                }
            }
            if (this.validKeys != null) {
                for (PGPPublicKey validKey : this.validKeys) {
                    builder.verified(validKey, false);
                }
            }
            if (this.failedKeys != null) {
                for (PGPPublicKey failedKey : this.failedKeys) {
                    builder.failed(failedKey);
                }
            }
            if (this.ignoredKeys != null) {
                for (String ignoredKey : this.ignoredKeys) {
                    builder.ignored(ignoredKey);
                }
            }
        }

        public boolean updated(HashCode originHash, HashCode signatureHash) {
            return !this.originHash.equals((Object)originHash) || !this.signatureHash.equals((Object)signatureHash);
        }
    }

    private static class CacheEntryBuilder
    implements SignatureVerificationResultBuilder {
        private final long timestamp;
        private final HashCode originHash;
        private final HashCode signatureHash;
        private List<String> missingKeys = null;
        private List<PGPPublicKey> trustedKeys = null;
        private List<PGPPublicKey> validKeys = null;
        private List<PGPPublicKey> failedKeys = null;
        private List<String> ignoredKeys = null;

        private CacheEntryBuilder(long timestamp, HashCode originHash, HashCode signatureHash) {
            this.timestamp = timestamp;
            this.originHash = originHash;
            this.signatureHash = signatureHash;
        }

        @Override
        public void missingKey(String keyId) {
            if (this.missingKeys == null) {
                this.missingKeys = Lists.newArrayList();
            }
            this.missingKeys.add(keyId);
        }

        @Override
        public void verified(PGPPublicKey key, boolean trusted) {
            if (trusted) {
                if (this.trustedKeys == null) {
                    this.trustedKeys = Lists.newArrayList();
                }
                this.trustedKeys.add(key);
            } else {
                if (this.validKeys == null) {
                    this.validKeys = Lists.newArrayList();
                }
                this.validKeys.add(key);
            }
        }

        @Override
        public void failed(PGPPublicKey pgpPublicKey) {
            if (this.failedKeys == null) {
                this.failedKeys = Lists.newArrayList();
            }
            this.failedKeys.add(pgpPublicKey);
        }

        @Override
        public void ignored(String keyId) {
            if (this.ignoredKeys == null) {
                this.ignoredKeys = Lists.newArrayList();
            }
            this.ignoredKeys.add(keyId);
        }

        CacheEntry build() {
            return new CacheEntry(this.timestamp, this.originHash, this.signatureHash, this.missingKeys, this.trustedKeys, this.validKeys, this.failedKeys, this.ignoredKeys);
        }
    }

    private static class CacheKeySerializer
    extends AbstractSerializer<CacheKey> {
        private final InterningStringSerializer delegate;
        private final SetSerializer<String> setSerializer;

        private CacheKeySerializer(InterningStringSerializer stringSerializer, SetSerializer<String> setSerializer) {
            this.delegate = stringSerializer;
            this.setSerializer = setSerializer;
        }

        public CacheKey read(Decoder decoder) throws Exception {
            return new CacheKey(this.delegate.read(decoder), this.delegate.read(decoder), (Set)this.setSerializer.read(decoder), (Set)this.setSerializer.read(decoder));
        }

        public void write(Encoder encoder, CacheKey value) throws Exception {
            this.delegate.write(encoder, value.filePath);
            this.delegate.write(encoder, value.signaturePath);
            this.setSerializer.write(encoder, (Collection)value.trustedKeys);
            this.setSerializer.write(encoder, (Collection)value.ignoredKeys);
        }
    }

    private static class CacheKey {
        private final String filePath;
        private final String signaturePath;
        private final Set<String> trustedKeys;
        private final Set<String> ignoredKeys;

        private CacheKey(String filePath, String signaturePath, Set<String> trustedKeys, Set<String> ignoredKeys) {
            this.filePath = filePath;
            this.signaturePath = signaturePath;
            this.trustedKeys = trustedKeys;
            this.ignoredKeys = ignoredKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.filePath.equals(cacheKey.filePath)) {
                return false;
            }
            if (!this.signaturePath.equals(cacheKey.signaturePath)) {
                return false;
            }
            if (!this.trustedKeys.equals(cacheKey.trustedKeys)) {
                return false;
            }
            return this.ignoredKeys.equals(cacheKey.ignoredKeys);
        }

        public int hashCode() {
            int result = this.filePath.hashCode();
            result = 31 * result + this.signaturePath.hashCode();
            result = 31 * result + this.trustedKeys.hashCode();
            result = 31 * result + this.ignoredKeys.hashCode();
            return result;
        }
    }
}

