/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u001b\u0010\b\u001a\u00020\u0001\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0004\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u001a\u0010\u0010\r\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000f0\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"RESERVED_MEMBER_NAME_SUFFIX", "", "SYNTHETIC_LOOP_LABEL", "jsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class NameTablesKt {
    /*
     * WARNING - void declaration
     */
    private static final <T> String mapToKey(T declaration2) {
        String string2;
        JsManglerIr jsManglerIr = JsManglerIr.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsManglerIr $this$mapToKey_u24lambda_u2d1 = jsManglerIr;
        boolean bl3 = false;
        if (declaration2 instanceof IrDeclaration) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashedMangle(declaration2));
        } else if (declaration2 instanceof String) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashMangle((String)declaration2));
        } else {
            String string3;
            String string4 = "Key is not generated for ";
            Object object = declaration2;
            if (object == null) {
                string3 = null;
            } else {
                void it;
                T t = object;
                boolean bl4 = false;
                boolean bl5 = false;
                T t2 = t;
                String string5 = string4;
                boolean bl6 = false;
                String string6 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                string4 = string5;
                string3 = string6;
            }
            object = Intrinsics.stringPlus((String)string4, string3);
            boolean bl7 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return string2;
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        return Intrinsics.stringPlus((String)"Names: \n", (Object)CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null));
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration2, @Nullable JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        boolean bl = !IrFunctionKt.isStaticMethodOfClass(declaration2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = declaration2.getDispatchReceiverParameter() != null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string4;
        if (MiscKt.hasStableJsName(declaration2, context2)) {
            boolean bl7 = !StringsKt.endsWith$default((String)declarationName, (String)"_k$", (boolean)false, (int)2, null);
            bl3 = false;
            bl4 = false;
            if (!bl7) {
                boolean bl8 = false;
                String string5 = "Function " + IrUtilsKt.getFqNameWhenAvailable(declaration2) + " uses reserved name suffix \"_k$\"";
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            return declarationName;
        }
        StringBuilder nameBuilder = new StringBuilder();
        Object $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty2 = false;
        Collection collection = $this$ifNotEmpty$iv;
        boolean bl9 = false;
        if (!collection.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d3 = (List)$this$ifNotEmpty$iv;
            boolean bl10 = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d3, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.2.1.INSTANCE, (int)60, null);
        }
        if (($this$ifNotEmpty$iv = declaration2.getExtensionReceiverParameter()) != null) {
            Object $i$f$ifNotEmpty2 = $this$ifNotEmpty$iv;
            boolean bl11 = false;
            bl9 = false;
            Object it = $i$f$ifNotEmpty2;
            boolean bl12 = false;
            nameBuilder.append(Intrinsics.stringPlus((String)"_r$", (Object)IrTypeUtilsKt.asString(((IrValueDeclaration)it).getType())));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        boolean $i$f$ifNotEmpty3 = false;
        Object object = $this$ifNotEmpty$iv;
        bl9 = false;
        if (!object.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d5 = (List)$this$ifNotEmpty$iv;
            boolean bl13 = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d5, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.4.1.INSTANCE, (int)60, null);
        }
        $this$ifNotEmpty$iv = declaration2.getReturnType();
        boolean bl14 = false;
        int n = 0;
        Object it = $this$ifNotEmpty$iv;
        boolean bl15 = false;
        if (IrTypeUtilsKt.getJsInlinedClass((IrType)it) != null || IrTypePredicatesKt.isUnit((IrType)it)) {
            nameBuilder.append(Intrinsics.stringPlus((String)"_ret$", (Object)IrTypeUtilsKt.asString((IrType)it)));
        }
        String string6 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"nameBuilder.toString()");
        String signature2 = string6;
        StringBuilder stringBuilder2 = new StringBuilder().append(NameTablesKt.sanitizeName(declarationName)).append('_');
        int n2 = signature2.hashCode();
        n = 0;
        n2 = Math.abs(n2);
        n = 36;
        boolean bl16 = false;
        String string7 = Integer.toString(n2, CharsKt.checkRadix((int)n));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        return stringBuilder2.append(string7).append("_k$").toString();
    }

    @NotNull
    public static final String sanitizeName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (NameSuggestionKt.isValidES5Identifier(name)) {
            return name;
        }
        CharSequence charSequence = name;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "_";
        }
        StringBuilder builder2 = new StringBuilder();
        int n = StringsKt.first((CharSequence)name);
        int n2 = 0;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        int first = NameSuggestionKt.isES5IdentifierStart((char)it) ? it : 95;
        builder2.append((char)first);
        n = 1;
        n2 = StringsKt.getLastIndex((CharSequence)name);
        if (n <= n2) {
            int idx;
            do {
                char c;
                builder2.append(NameSuggestionKt.isES5IdentifierPart(c = name.charAt(idx = n++)) ? c : (char)'_');
            } while (idx != n2);
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return string2;
    }

    public static final /* synthetic */ String access$mapToKey(Object declaration2) {
        return NameTablesKt.mapToKey(declaration2);
    }
}

