/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIntrinsicTransformers;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrClassModel;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.NameScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0096\u0001\u00a2\u0006\u0002\u0010!J\u0011\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0096\u0001J\u0011\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0096\u0001J\u0011\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010+\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0096\u0001J\u0011\u0010/\u001a\u00020#2\u0006\u00100\u001a\u000201H\u0096\u0001J\u0011\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0096\u0001J\u0011\u00105\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0096\u0001J\u0011\u00106\u001a\u0002072\u0006\u0010$\u001a\u00020\u0011H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "backendContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "irNamer", "globalNameScope", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameScope;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;Lorg/jetbrains/kotlin/ir/backend/js/utils/NameScope;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "classModels", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrClassModel;", "getClassModels", "()Ljava/util/Map;", "coroutineImplDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getCoroutineImplDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getGlobalNameScope", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameScope;", "initializerBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "getInitializerBlock", "()Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIntrinsicTransformers;", "getIntrinsics", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIntrinsicTransformers;", "getAssociatedObjectKey", "", "irClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForStaticFunction", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "backend.js"})
public final class JsStaticContext
implements IrNamer {
    @NotNull
    private final JsIrBackendContext backendContext;
    @NotNull
    private final IrNamer irNamer;
    @NotNull
    private final NameScope globalNameScope;
    @NotNull
    private final JsIntrinsicTransformers intrinsics;
    @NotNull
    private final Map<IrClassSymbol, JsIrClassModel> classModels;
    @NotNull
    private final IrClass coroutineImplDeclaration;
    @NotNull
    private final JsGlobalBlock initializerBlock;

    public JsStaticContext(@NotNull JsIrBackendContext backendContext, @NotNull IrNamer irNamer, @NotNull NameScope globalNameScope) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)irNamer, (String)"irNamer");
        Intrinsics.checkNotNullParameter((Object)globalNameScope, (String)"globalNameScope");
        this.backendContext = backendContext;
        this.irNamer = irNamer;
        this.globalNameScope = globalNameScope;
        this.intrinsics = new JsIntrinsicTransformers(this.backendContext);
        boolean bl = false;
        this.classModels = new LinkedHashMap();
        this.coroutineImplDeclaration = (IrClass)this.backendContext.getIr().getSymbols().getCoroutineImpl().getOwner();
        this.initializerBlock = new JsGlobalBlock();
    }

    @NotNull
    public final JsIrBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final NameScope getGlobalNameScope() {
        return this.globalNameScope;
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        return this.irNamer.getAssociatedObjectKey(irClass2);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.irNamer.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        return this.irNamer.getNameForConstructor(constructor2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.irNamer.getNameForField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.irNamer.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.irNamer.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return this.irNamer.getNameForProperty(property2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.irNamer.getNameForStaticDeclaration(declaration2);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.irNamer.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.irNamer.getRefForExternalClass(klass);
    }

    @NotNull
    public final JsIntrinsicTransformers getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public final Map<IrClassSymbol, JsIrClassModel> getClassModels() {
        return this.classModels;
    }

    @NotNull
    public final IrClass getCoroutineImplDeclaration() {
        return this.coroutineImplDeclaration;
    }

    @NotNull
    public final JsGlobalBlock getInitializerBlock() {
        return this.initializerBlock;
    }
}

