/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.StartUpMeasurer;

@ApiStatus.Internal
public enum LoadingState {
    BOOTSTRAP("bootstrap"),
    LAF_INITIALIZED("LaF is initialized"),
    COMPONENTS_REGISTERED("app component registered"),
    CONFIGURATION_STORE_INITIALIZED("app store initialized"),
    COMPONENTS_LOADED("app component loaded"),
    APP_STARTED("app started"),
    PROJECT_OPENED("project opened"),
    INDEXING_FINISHED("indexing finished");

    final String displayName;
    private static BiConsumer<String, Throwable> errorHandler;
    private static boolean CHECK_LOADING_PHASE;
    private static Set<Throwable> stackTraces;

    private LoadingState(String displayName) {
        if (displayName == null) {
            LoadingState.$$$reportNull$$$0(0);
        }
        this.displayName = displayName;
    }

    @Nullable
    static BiConsumer<String, Throwable> getErrorHandler() {
        return errorHandler;
    }

    public void checkOccurred() {
        if (!CHECK_LOADING_PHASE) {
            return;
        }
        LoadingState currentState = StartUpMeasurer.currentState.get();
        if (currentState.compareTo(this) >= 0 || LoadingState.isKnownViolator()) {
            return;
        }
        this.logStateError(currentState);
    }

    private synchronized void logStateError(@NotNull LoadingState currentState) {
        if (currentState == null) {
            LoadingState.$$$reportNull$$$0(2);
        }
        Throwable t = new Throwable();
        if (stackTraces == null) {
            stackTraces = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Throwable>(){

                public int hashCode(Throwable throwable) {
                    return this.fingerprint(throwable).hashCode();
                }

                public boolean equals(Throwable o1, Throwable o2) {
                    return o1 == o2 || o1 != null && o2 != null && this.fingerprint(o1).equals(this.fingerprint(o2));
                }

                private String fingerprint(Throwable throwable) {
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement traceElement : throwable.getStackTrace()) {
                        sb.append(traceElement.getClassName()).append(traceElement.getMethodName());
                    }
                    return sb.toString();
                }
            });
        }
        if (!stackTraces.add(t)) {
            return;
        }
        BiConsumer<String, Throwable> errorHandler = LoadingState.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.accept("Should be called at least in the state " + (Object)((Object)this) + ", the current state is: " + (Object)((Object)currentState) + "\nCurrent violators count: " + stackTraces.size() + "\n\n", t);
        }
    }

    private static boolean isKnownViolator() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            String className2 = element.getClassName();
            if (!className2.contains("org.jetbrains.kotlin.com.intellij.util.indexing.IndexInfrastructure") && !className2.contains("org.jetbrains.kotlin.com.intellij.psi.impl.search.IndexPatternSearcher") && !className2.contains("com.jetbrains.performancePlugin.ProjectLoaded") && !className2.contains("com.jetbrains.python.conda.InstallCondaUtils")) continue;
            return true;
        }
        return false;
    }

    public boolean isOccurred() {
        return StartUpMeasurer.currentState.get().compareTo(this) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/LoadingState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "logStateError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

