/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "binaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)V", "constantCache", "", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirConstant", "protoValue", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value;", "sourceValue", "constKind", "", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "loadConstant", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "replaceName", "newName", "Lorg/jetbrains/kotlin/name/Name;", "fir-deserialization"})
public final class FirConstDeserializer {
    @NotNull
    private final FirSession session;
    @Nullable
    private final KotlinJvmBinaryClass binaryClass;
    @NotNull
    private final Map<CallableId, FirExpression> constantCache;

    public FirConstDeserializer(@NotNull FirSession session2, @Nullable KotlinJvmBinaryClass binaryClass) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.binaryClass = binaryClass;
        boolean bl = false;
        this.constantCache = new LinkedHashMap();
    }

    public /* synthetic */ FirConstDeserializer(FirSession firSession, KotlinJvmBinaryClass kotlinJvmBinaryClass2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kotlinJvmBinaryClass2 = null;
        }
        this(firSession, kotlinJvmBinaryClass2);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Nullable
    public final FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirExpression firExpression2 = this.constantCache.get(callableId);
        if (firExpression2 != null) {
            FirExpression firExpression3 = firExpression2;
            boolean bl = false;
            boolean bl2 = false;
            FirExpression it = firExpression3;
            boolean bl3 = false;
            return it;
        }
        if (this.binaryClass == null) {
            Object object;
            Object object2 = ProtoBufUtilKt.getExtensionOrNull(propertyProto, BuiltInSerializerProtocol.INSTANCE.getCompileTimeValue());
            if (object2 == null) {
                return null;
            }
            Object value2 = object2;
            if ((object2 = this.buildFirConstant((ProtoBuf.Annotation.Argument.Value)value2, null, ((ProtoBuf.Annotation.Argument.Value)value2).getType().name(), nameResolver2)) == null) {
                object = null;
            } else {
                Object object3 = object2;
                boolean bl = false;
                boolean bl4 = false;
                Object $this$loadConstant_u24lambda_u2d1 = object3;
                boolean bl5 = false;
                Map<CallableId, FirExpression> map = this.constantCache;
                boolean bl6 = false;
                map.put(callableId, (FirExpression)$this$loadConstant_u24lambda_u2d1);
                object = object3;
            }
            return object;
        }
        this.binaryClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, nameResolver2, callableId){
            final /* synthetic */ FirConstDeserializer this$0;
            final /* synthetic */ NameResolver $nameResolver;
            final /* synthetic */ CallableId $callableId;
            {
                this.this$0 = $receiver;
                this.$nameResolver = $nameResolver;
                this.$callableId = $callableId;
            }

            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                return null;
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer2) {
                FirExpression constant;
                FirExpression firExpression2;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                if (initializer2 != null && (firExpression2 = (constant = FirConstDeserializer.access$buildFirConstant(this.this$0, null, initializer2, desc, this.$nameResolver))) != null) {
                    FirExpression firExpression3 = firExpression2;
                    FirConstDeserializer firConstDeserializer = this.this$0;
                    CallableId callableId = this.$callableId;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirExpression it = firExpression3;
                    boolean bl3 = false;
                    Map map = FirConstDeserializer.access$getConstantCache$p(firConstDeserializer);
                    CallableId callableId2 = FirConstDeserializer.access$replaceName(firConstDeserializer, callableId, name);
                    boolean bl4 = false;
                    map.put(callableId2, it);
                }
                return null;
            }
        }, null);
        return this.constantCache.get(callableId);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression buildFirConstant(ProtoBuf.Annotation.Argument.Value protoValue, Object sourceValue, String constKind, NameResolver nameResolver2) {
        FirExpression firExpression2;
        switch (constKind) {
            case "B": 
            case "BYTE": {
                Object object;
                Object object2;
                FirConstKind firConstKind = FirConstKind.Byte.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value2 = protoValue;
                if (value2 == null) {
                    object2 = sourceValue;
                } else {
                    long l = value2.getIntValue();
                    object2 = object = Long.valueOf(l);
                }
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, ((Number)object).byteValue(), null, 8, null);
                break;
            }
            case "C": 
            case "CHAR": {
                Object object;
                Object object3;
                FirConstKind firConstKind = FirConstKind.Char.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value3 = protoValue;
                if (value3 == null) {
                    object3 = sourceValue;
                } else {
                    long l = value3.getIntValue();
                    object3 = object = Long.valueOf(l);
                }
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, Character.valueOf((char)((Number)object).intValue()), null, 8, null);
                break;
            }
            case "SHORT": 
            case "S": {
                Object object;
                Object object4;
                FirConstKind firConstKind = FirConstKind.Short.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value4 = protoValue;
                if (value4 == null) {
                    object4 = sourceValue;
                } else {
                    long l = value4.getIntValue();
                    object4 = object = Long.valueOf(l);
                }
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, ((Number)object).shortValue(), null, 8, null);
                break;
            }
            case "I": 
            case "INT": {
                int n;
                Integer n2;
                Integer n3;
                FirConstKind firConstKind = FirConstKind.Int.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value5 = protoValue;
                if (value5 == null) {
                    n3 = null;
                } else {
                    long l = value5.getIntValue();
                    n3 = n2 = Integer.valueOf((int)l);
                }
                if (n2 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    n = (Integer)sourceValue;
                } else {
                    n = n2;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, n, null, 8, null);
                break;
            }
            case "J": 
            case "LONG": {
                long l;
                Long l2;
                FirConstKind firConstKind = FirConstKind.Long.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value6 = protoValue;
                Long l3 = l2 = value6 == null ? null : Long.valueOf(value6.getIntValue());
                if (l2 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    l = (Long)sourceValue;
                } else {
                    l = l2;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, l, null, 8, null);
                break;
            }
            case "FLOAT": 
            case "F": {
                float f;
                Float f2;
                FirConstKind firConstKind = FirConstKind.Float.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value7 = protoValue;
                Float f3 = f2 = value7 == null ? null : Float.valueOf(value7.getFloatValue());
                if (f2 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    f = ((Float)sourceValue).floatValue();
                } else {
                    f = f2.floatValue();
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, Float.valueOf(f), null, 8, null);
                break;
            }
            case "D": 
            case "DOUBLE": {
                double d;
                Double d2;
                FirConstKind firConstKind = FirConstKind.Double.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value8 = protoValue;
                Double d3 = d2 = value8 == null ? null : Double.valueOf(value8.getDoubleValue());
                if (d2 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                    }
                    d = (Double)sourceValue;
                } else {
                    d = d2;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, d, null, 8, null);
                break;
            }
            case "BOOLEAN": 
            case "Z": {
                Object object;
                Long l;
                FirConstKind firConstKind = FirConstKind.Boolean.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value9 = protoValue;
                Long l4 = l = value9 == null ? null : Long.valueOf(value9.getIntValue());
                if (l == null) {
                    object = sourceValue;
                } else {
                    int n = (int)l.longValue();
                    object = n;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, firConstKind, !Intrinsics.areEqual((Object)object, (Object)0), null, 8, null);
                break;
            }
            case "Ljava/lang/String;": 
            case "STRING": {
                String string2;
                String string3;
                FirSourceElement firSourceElement = null;
                FirConstKind firConstKind = FirConstKind.String.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value10 = protoValue;
                if (value10 == null) {
                    string3 = null;
                } else {
                    void it;
                    int n;
                    int n4 = n = value10.getStringValue();
                    boolean bl = false;
                    boolean bl2 = false;
                    int n5 = n4;
                    FirConstKind firConstKind2 = firConstKind;
                    FirSourceElement firSourceElement2 = firSourceElement;
                    boolean bl3 = false;
                    String string4 = nameResolver2.getString((int)it);
                    firSourceElement = firSourceElement2;
                    firConstKind = firConstKind2;
                    string3 = string4;
                }
                String string5 = string3;
                if (string5 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)sourceValue;
                } else {
                    string2 = string5;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(firSourceElement, firConstKind, string2, null, 8, null);
                break;
            }
            default: {
                firExpression2 = null;
            }
        }
        return firExpression2;
    }

    private final CallableId replaceName(CallableId $this$replaceName, Name newName2) {
        return new CallableId($this$replaceName.getPackageName(), $this$replaceName.getClassName(), newName2, null, 8, null);
    }

    public static final /* synthetic */ FirExpression access$buildFirConstant(FirConstDeserializer $this, ProtoBuf.Annotation.Argument.Value protoValue, Object sourceValue, String constKind, NameResolver nameResolver2) {
        return $this.buildFirConstant(protoValue, sourceValue, constKind, nameResolver2);
    }

    public static final /* synthetic */ Map access$getConstantCache$p(FirConstDeserializer $this) {
        return $this.constantCache;
    }

    public static final /* synthetic */ CallableId access$replaceName(FirConstDeserializer $this, CallableId $receiver, Name newName2) {
        return $this.replaceName($receiver, newName2);
    }
}

