/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.util.internal.GFileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstrumentingClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentingClasspathFileTransformer.class);
    private static final int CACHE_FORMAT = 4;
    private final FileLockManager fileLockManager;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final CachedClasspathTransformer.Transform transform;
    private final HashCode configHash;

    public InstrumentingClasspathFileTransformer(FileLockManager fileLockManager, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, CachedClasspathTransformer.Transform transform) {
        this.fileLockManager = fileLockManager;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.transform = transform;
        this.configHash = this.configHashFor(transform);
    }

    private HashCode configHashFor(CachedClasspathTransformer.Transform transform) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putInt(4);
        transform.applyConfigurationTo(hasher);
        return hasher.hash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        String destDirName = this.hashOf(sourceSnapshot);
        File destDir = new File(cacheDir, destDirName);
        String destFileName = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName();
        File receipt = new File(destDir, destFileName + ".receipt");
        File transformed = new File(destDir, destFileName);
        if (receipt.isFile()) {
            return transformed;
        }
        File lockFile = new File(destDir, destFileName + ".lock");
        try (FileLock fileLock = this.exclusiveLockFor(lockFile);){
            if (receipt.isFile()) {
                File file = transformed;
                return file;
            }
            this.transform(source, transformed);
            try {
                receipt.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create receipt for instrumented classpath file '%s/%s'.", destDirName, destFileName), (Throwable)e);
            }
            File file = transformed;
            return file;
        }
    }

    private FileLock exclusiveLockFor(File file) {
        return this.fileLockManager.lock(file, (LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation(), "instrumented jar cache");
    }

    private String hashOf(FileSystemLocationSnapshot sourceSnapshot) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putHash(this.configHash);
        hasher.putHash(sourceSnapshot.getHash());
        return hasher.hash().toString();
    }

    private void transform(File source, File dest) {
        if (this.isSignedJar(source)) {
            LOGGER.debug("Signed archive '{}'. Skipping instrumentation.", (Object)source.getName());
            GFileUtils.copyFile((File)source, (File)dest);
        } else {
            this.instrument(source, dest);
        }
    }

    private void instrument(File source, File dest) {
        this.classpathBuilder.jar(dest, builder -> {
            try {
                this.visitEntries(source, builder);
            }
            catch (FileException e) {
                LOGGER.debug("Malformed archive '{}'. Discarding contents.", (Object)source.getName(), (Object)e);
            }
        });
    }

    private void visitEntries(File source, ClasspathBuilder.EntryBuilder builder) throws IOException, FileException {
        this.classpathWalker.visit(source, entry -> {
            if (entry.getName().endsWith(".class")) {
                ClassReader reader = new ClassReader(entry.getContent());
                ClassWriter classWriter = new ClassWriter(1);
                Pair<RelativePath, ClassVisitor> chain = this.transform.apply(entry, (ClassVisitor)classWriter);
                reader.accept((ClassVisitor)chain.right, 0);
                byte[] bytes = classWriter.toByteArray();
                builder.put(((RelativePath)chain.left).getPathString(), bytes);
            } else {
                builder.put(entry.getName(), entry.getContent());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSignedJar(File source) {
        if (!source.isFile()) {
            return false;
        }
        try (ZipInput entries2 = FileZipInput.create((File)source);){
            ZipEntry entry;
            String entryName;
            Iterator iterator = entries2.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(entryName = (entry = (ZipEntry)iterator.next()).getName()).startsWith("META-INF/") || !entryName.endsWith(".SF"));
            boolean bl = true;
            return bl;
        }
        catch (FileException entries2) {
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

