/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyBundleValueSource;
import org.gradle.api.internal.catalog.DependencyValueSource;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class AbstractExternalDependencyFactory
implements ExternalModuleDependencyFactory {
    protected final DefaultVersionCatalog config;
    protected final ProviderFactory providers;

    @Inject
    protected AbstractExternalDependencyFactory(DefaultVersionCatalog config, ProviderFactory providers) {
        this.config = config;
        this.providers = providers;
    }

    protected Provider<MinimalExternalModuleDependency> create(String alias) {
        return this.providers.of(DependencyValueSource.class, spec -> ((DependencyValueSource.Params)spec.getParameters()).getDependencyData().set((Object)this.config.getDependencyData(alias))).forUseAtConfigurationTime();
    }

    public final Optional<Provider<MinimalExternalModuleDependency>> findDependency(String alias) {
        if (this.config.getDependencyAliases().contains(alias)) {
            return Optional.of(this.create(alias));
        }
        return Optional.empty();
    }

    public final Optional<Provider<ExternalModuleDependencyBundle>> findBundle(String bundle) {
        if (this.config.getBundleAliases().contains(bundle)) {
            return Optional.of(new BundleFactory(this.providers, this.config).createBundle(bundle));
        }
        return Optional.empty();
    }

    public final Optional<VersionConstraint> findVersion(String name) {
        if (this.config.getVersionAliases().contains(name)) {
            return Optional.of(new VersionFactory(this.providers, this.config).findVersionConstraint(name));
        }
        return Optional.empty();
    }

    public final String getName() {
        return this.config.getName();
    }

    public List<String> getDependencyAliases() {
        return this.config.getDependencyAliases();
    }

    public List<String> getBundleAliases() {
        return this.config.getBundleAliases();
    }

    public List<String> getVersionAliases() {
        return this.config.getVersionAliases();
    }

    public static class BundleFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public BundleFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<ExternalModuleDependencyBundle> createBundle(String name) {
            return this.providers.of(DependencyBundleValueSource.class, spec -> spec.parameters(params -> {
                params.getConfig().set((Object)this.config);
                params.getBundleName().set((Object)name);
            })).forUseAtConfigurationTime();
        }
    }

    public static class VersionFactory {
        protected final ProviderFactory providers;
        protected final DefaultVersionCatalog config;

        public VersionFactory(ProviderFactory providers, DefaultVersionCatalog config) {
            this.providers = providers;
            this.config = config;
        }

        protected Provider<String> getVersion(String name) {
            return this.providers.provider(() -> this.doGetVersion(name));
        }

        private String doGetVersion(String name) {
            ImmutableVersionConstraint version = this.findVersionConstraint(name);
            String requiredVersion = version.getRequiredVersion();
            if (!requiredVersion.isEmpty()) {
                return requiredVersion;
            }
            String strictVersion = version.getStrictVersion();
            if (!strictVersion.isEmpty()) {
                return strictVersion;
            }
            return version.getPreferredVersion();
        }

        private ImmutableVersionConstraint findVersionConstraint(String name) {
            return this.config.getVersion(name).getVersion();
        }
    }

    public static abstract class SubDependencyFactory
    implements ExternalModuleDependencyFactory {
        protected final AbstractExternalDependencyFactory owner;

        protected SubDependencyFactory(AbstractExternalDependencyFactory owner) {
            this.owner = owner;
        }

        protected Provider<MinimalExternalModuleDependency> create(String alias) {
            return this.owner.create(alias);
        }

        public Optional<Provider<MinimalExternalModuleDependency>> findDependency(String alias) {
            return this.owner.findDependency(alias);
        }

        public Optional<Provider<ExternalModuleDependencyBundle>> findBundle(String bundle) {
            return this.owner.findBundle(bundle);
        }

        public Optional<VersionConstraint> findVersion(String name) {
            return this.owner.findVersion(name);
        }

        public String getName() {
            return this.owner.getName();
        }

        public List<String> getDependencyAliases() {
            return this.owner.getDependencyAliases();
        }

        public List<String> getBundleAliases() {
            return this.owner.getBundleAliases();
        }

        public List<String> getVersionAliases() {
            return this.owner.getVersionAliases();
        }
    }
}

