/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;

public interface SnapshotHierarchy {
    public Optional<MetadataSnapshot> getMetadata(String var1);

    default public Optional<FileSystemLocationSnapshot> getSnapshot(String absolutePath) {
        return this.getMetadata(absolutePath).filter(FileSystemLocationSnapshot.class::isInstance).map(FileSystemLocationSnapshot.class::cast);
    }

    public boolean hasDescendantsUnder(String var1);

    @CheckReturnValue
    public SnapshotHierarchy store(String var1, MetadataSnapshot var2, NodeDiffListener var3);

    @CheckReturnValue
    public SnapshotHierarchy invalidate(String var1, NodeDiffListener var2);

    @CheckReturnValue
    public SnapshotHierarchy empty();

    public void visitSnapshotRoots(SnapshotVisitor var1);

    public void visitSnapshotRoots(String var1, SnapshotVisitor var2);

    public static interface SnapshotDiffListener {
        public static final SnapshotDiffListener NOOP = (removedSnapshots, addedSnapshots) -> {};

        public void changed(Collection<FileSystemLocationSnapshot> var1, Collection<FileSystemLocationSnapshot> var2);
    }

    public static interface NodeDiffListener {
        public static final NodeDiffListener NOOP = new NodeDiffListener(){

            @Override
            public void nodeRemoved(FileSystemNode node) {
            }

            @Override
            public void nodeAdded(FileSystemNode node) {
            }
        };

        public void nodeRemoved(FileSystemNode var1);

        public void nodeAdded(FileSystemNode var1);
    }

    public static interface SnapshotVisitor {
        public void visitSnapshotRoot(FileSystemLocationSnapshot var1);
    }
}

