/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import javax.inject.Inject;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.cpp.internal.NativeDependencyCache;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.internal.DefaultNativeBinary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppBinary
extends DefaultNativeBinary
implements CppBinary {
    private final Provider<String> baseName;
    private final FileCollection sourceFiles;
    private final FileCollection includePath;
    private final Configuration linkLibraries;
    private final FileCollection runtimeLibraries;
    private final CppPlatform targetPlatform;
    private final NativeToolChainInternal toolChain;
    private final PlatformToolProvider platformToolProvider;
    private final Configuration includePathConfiguration;
    private final Property<CppCompile> compileTaskProperty;
    private final NativeVariantIdentity identity;

    public DefaultCppBinary(Names names, ObjectFactory objects, Provider<String> baseName, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration componentImplementation, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(names, objects, componentImplementation);
        this.baseName = baseName;
        this.sourceFiles = sourceFiles;
        this.targetPlatform = targetPlatform;
        this.toolChain = toolChain;
        this.platformToolProvider = platformToolProvider;
        this.compileTaskProperty = objects.property(CppCompile.class);
        this.identity = identity;
        this.includePathConfiguration = (Configuration)configurations.create(names.withPrefix("cppCompile"));
        this.includePathConfiguration.setCanBeConsumed(false);
        this.includePathConfiguration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "cplusplus-api")));
        this.includePathConfiguration.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        this.includePathConfiguration.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        this.includePathConfiguration.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        this.includePathConfiguration.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        this.includePathConfiguration.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        Configuration nativeLink = (Configuration)configurations.create(names.withPrefix("nativeLink"));
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "native-link")));
        nativeLink.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        nativeLink.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        nativeLink.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        nativeLink.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        nativeLink.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        Configuration nativeRuntime = (Configuration)configurations.create(names.withPrefix("nativeRuntime"));
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, "native-runtime")));
        nativeRuntime.getAttributes().attribute(DEBUGGABLE_ATTRIBUTE, (Object)identity.isDebuggable());
        nativeRuntime.getAttributes().attribute(OPTIMIZED_ATTRIBUTE, (Object)identity.isOptimized());
        nativeRuntime.getAttributes().attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)identity.getTargetMachine().getOperatingSystemFamily());
        nativeRuntime.getAttributes().attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)identity.getTargetMachine().getArchitecture());
        nativeRuntime.extendsFrom(new Configuration[]{this.getImplementationDependencies()});
        ArtifactView includeDirs = this.includePathConfiguration.getIncoming().artifactView(viewConfiguration -> viewConfiguration.attributes(attributeContainer -> attributeContainer.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"directory")));
        this.includePath = componentHeaderDirs.plus(includeDirs.getFiles());
        this.linkLibraries = nativeLink;
        this.runtimeLibraries = nativeRuntime;
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TemporaryFileProvider getTemporaryFileProvider() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected NativeDependencyCache getNativeDependencyCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Provider<String> getBaseName() {
        return this.baseName;
    }

    @Override
    public boolean isDebuggable() {
        return this.identity.isDebuggable();
    }

    @Override
    public boolean isOptimized() {
        return this.identity.isOptimized();
    }

    @Override
    public FileCollection getCppSource() {
        return this.sourceFiles;
    }

    @Override
    public FileCollection getCompileIncludePath() {
        return this.includePath;
    }

    @Override
    public FileCollection getLinkLibraries() {
        return this.linkLibraries;
    }

    public Configuration getLinkConfiguration() {
        return this.linkLibraries;
    }

    @Override
    public FileCollection getRuntimeLibraries() {
        return this.runtimeLibraries;
    }

    public Configuration getIncludePathConfiguration() {
        return this.includePathConfiguration;
    }

    @Override
    public TargetMachine getTargetMachine() {
        return this.targetPlatform.getTargetMachine();
    }

    @Override
    public CppPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public NativePlatform getNativePlatform() {
        return ((DefaultCppPlatform)this.targetPlatform).getNativePlatform();
    }

    public NativeToolChainInternal getToolChain() {
        return this.toolChain;
    }

    public Property<CppCompile> getCompileTask() {
        return this.compileTaskProperty;
    }

    public PlatformToolProvider getPlatformToolProvider() {
        return this.platformToolProvider;
    }

    public NativeVariantIdentity getIdentity() {
        return this.identity;
    }
}

