/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public enum PrimitiveUnaryOperationFIF implements FunctionIntrinsicFactory
{
    INSTANCE;

    private static final NamePredicate UNARY_OPERATIONS;
    @NotNull
    private static final DescriptorPredicate UNARY_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final Predicate<FunctionDescriptor> PRIMITIVE_UNARY_OPERATION_NAMES;
    @NotNull
    private static final DescriptorPredicate NO_PARAMETERS;
    @NotNull
    private static final Predicate<FunctionDescriptor> PATTERN;
    private static final DescriptorPredicate INC_OPERATION_FOR_INT;
    private static final DescriptorPredicate DEC_OPERATION_FOR_INT;
    private static final DescriptorPredicate INC_OPERATION_FOR_BYTE;
    private static final DescriptorPredicate DEC_OPERATION_FOR_BYTE;
    private static final DescriptorPredicate INC_OPERATION_FOR_SHORT;
    private static final DescriptorPredicate DEC_OPERATION_FOR_SHORT;
    private static final DescriptorPredicate NEG_OPERATION_FOR_INT;
    @NotNull
    private static final DescriptorPredicate INC_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final DescriptorPredicate DEC_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final FunctionIntrinsicWithReceiverComputed NUMBER_INC_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsicWithReceiverComputed NUMBER_DEC_INTRINSIC;
    private static final FunctionIntrinsicWithReceiverComputed NUMBER_NEG_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic CHAR_PLUS;
    @NotNull
    private static final FunctionIntrinsic CHAR_MINUS;
    @NotNull
    private static final FunctionIntrinsic CHAR_INC;
    @NotNull
    private static final FunctionIntrinsic CHAR_DEC;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context2) {
        JsUnaryOperator jsOperator;
        if (descriptor2 == null) {
            PrimitiveUnaryOperationFIF.$$$reportNull$$$1(0);
        }
        if (context2 == null) {
            PrimitiveUnaryOperationFIF.$$$reportNull$$$1(1);
        }
        if (descriptor2 == null) {
            PrimitiveUnaryOperationFIF.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PrimitiveUnaryOperationFIF.$$$reportNull$$$0(1);
        }
        if (!PATTERN.test(descriptor2)) {
            return null;
        }
        if (PatternBuilder.pattern("Char.unaryPlus()").test(descriptor2)) {
            return CHAR_PLUS;
        }
        if (PatternBuilder.pattern("Char.unaryMinus()").test(descriptor2)) {
            return CHAR_MINUS;
        }
        if (PatternBuilder.pattern("Char.plus()").test(descriptor2)) {
            return CHAR_PLUS;
        }
        if (PatternBuilder.pattern("Char.minus()").test(descriptor2)) {
            return CHAR_MINUS;
        }
        if (PatternBuilder.pattern("Char.inc()").test(descriptor2)) {
            return CHAR_INC;
        }
        if (PatternBuilder.pattern("Char.dec()").test(descriptor2)) {
            return CHAR_DEC;
        }
        if (INC_OPERATION_FOR_INT.test(descriptor2)) {
            return new IntOverflowIntrinsic(NUMBER_INC_INTRINSIC);
        }
        if (DEC_OPERATION_FOR_INT.test(descriptor2)) {
            return new IntOverflowIntrinsic(NUMBER_DEC_INTRINSIC);
        }
        if (INC_OPERATION_FOR_SHORT.test(descriptor2)) {
            return new ShortOverflowIntrinsic(NUMBER_INC_INTRINSIC);
        }
        if (DEC_OPERATION_FOR_SHORT.test(descriptor2)) {
            return new ShortOverflowIntrinsic(NUMBER_DEC_INTRINSIC);
        }
        if (INC_OPERATION_FOR_BYTE.test(descriptor2)) {
            return new ByteOverflowIntrinsic(NUMBER_INC_INTRINSIC);
        }
        if (DEC_OPERATION_FOR_BYTE.test(descriptor2)) {
            return new ByteOverflowIntrinsic(NUMBER_DEC_INTRINSIC);
        }
        if (INC_OPERATION_FOR_PRIMITIVE_NUMBER.test(descriptor2)) {
            return NUMBER_INC_INTRINSIC;
        }
        if (DEC_OPERATION_FOR_PRIMITIVE_NUMBER.test(descriptor2)) {
            return NUMBER_DEC_INTRINSIC;
        }
        if (NEG_OPERATION_FOR_INT.test(descriptor2)) {
            return new IntOverflowIntrinsic(NUMBER_NEG_INTRINSIC);
        }
        Name name = descriptor2.getName();
        if ("inv".equals(name.asString())) {
            jsOperator = JsUnaryOperator.BIT_NOT;
        } else {
            KtToken jetToken = (KtToken)((ImmutableMap)((Object)OperatorConventions.UNARY_OPERATION_NAMES.inverse())).get(name);
            jsOperator = OperatorTable.getUnaryOperator(jetToken);
        }
        final JsUnaryOperator finalJsOperator = jsOperator;
        return new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
                if (arguments2 == null) {
                    8.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    8.$$$reportNull$$$1(1);
                }
                if (arguments2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    8.$$$reportNull$$$0(1);
                }
                assert (receiver != null);
                assert (arguments2.size() == 0) : "Unary operator should not have arguments.";
                return new JsPrefixOperation(finalJsOperator, receiver);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$8";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$8";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static {
        UNARY_OPERATIONS = new NamePredicate(OperatorNameConventions.UNARY_OPERATION_NAMES);
        UNARY_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, UNARY_OPERATIONS);
        PRIMITIVE_UNARY_OPERATION_NAMES = UNARY_OPERATION_FOR_PRIMITIVE_NUMBER.or(PatternBuilder.pattern("Boolean.not")).or(PatternBuilder.pattern("Int|Short|Byte.inv"));
        NO_PARAMETERS = descriptor2 -> !JsDescriptorUtils.hasParameters(descriptor2);
        PATTERN = PRIMITIVE_UNARY_OPERATION_NAMES.and(NO_PARAMETERS);
        INC_OPERATION_FOR_INT = PatternBuilder.pattern("Int.inc");
        DEC_OPERATION_FOR_INT = PatternBuilder.pattern("Int.dec");
        INC_OPERATION_FOR_BYTE = PatternBuilder.pattern("Byte.inc");
        DEC_OPERATION_FOR_BYTE = PatternBuilder.pattern("Byte.dec");
        INC_OPERATION_FOR_SHORT = PatternBuilder.pattern("Short.inc");
        DEC_OPERATION_FOR_SHORT = PatternBuilder.pattern("Short.dec");
        NEG_OPERATION_FOR_INT = PatternBuilder.pattern("Int.unaryMinus");
        INC_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern("Float|Double.inc()");
        DEC_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern("Float|Double.dec()");
        NUMBER_INC_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
                if (arguments2 == null) {
                    1.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$1(1);
                }
                if (arguments2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                assert (receiver != null);
                assert (arguments2.size() == 0);
                return new JsBinaryOperation(JsBinaryOperator.ADD, receiver, new JsIntLiteral(1));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$1";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$1";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NUMBER_DEC_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
                if (arguments2 == null) {
                    2.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$1(1);
                }
                if (arguments2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                assert (receiver != null);
                assert (arguments2.size() == 0);
                return new JsBinaryOperation(JsBinaryOperator.SUB, receiver, new JsIntLiteral(1));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$2";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$2";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NUMBER_NEG_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
                if (arguments2 == null) {
                    3.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    3.$$$reportNull$$$1(1);
                }
                if (arguments2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                assert (receiver != null);
                assert (arguments2.size() == 0);
                return new JsPrefixOperation(JsUnaryOperator.NEG, receiver);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$3";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "arguments";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$3";
                objectArray[2] = "apply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CHAR_PLUS = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context2) {
                if (receiver == null) {
                    4.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    4.$$$reportNull$$$1(1);
                }
                if (receiver == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                JsExpression jsExpression = JsAstUtils.charToInt(receiver);
                if (jsExpression == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (jsExpression == null) {
                    4.$$$reportNull$$$1(2);
                }
                return jsExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CHAR_MINUS = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context2) {
                if (receiver == null) {
                    5.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    5.$$$reportNull$$$1(1);
                }
                if (receiver == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                return new JsPrefixOperation(JsUnaryOperator.NEG, JsAstUtils.charToInt(receiver));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$5";
                objectArray[2] = "doApply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$5";
                objectArray[2] = "doApply";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CHAR_INC = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context2) {
                if (receiver == null) {
                    6.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    6.$$$reportNull$$$1(1);
                }
                if (receiver == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    6.$$$reportNull$$$0(1);
                }
                JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("charInc", receiver);
                if (jsInvocation == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (jsInvocation == null) {
                    6.$$$reportNull$$$1(2);
                }
                return jsInvocation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CHAR_DEC = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context2) {
                if (receiver == null) {
                    7.$$$reportNull$$$1(0);
                }
                if (context2 == null) {
                    7.$$$reportNull$$$1(1);
                }
                if (receiver == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    7.$$$reportNull$$$0(1);
                }
                JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("charDec", receiver);
                if (jsInvocation == null) {
                    7.$$$reportNull$$$0(2);
                }
                if (jsInvocation == null) {
                    7.$$$reportNull$$$1(2);
                }
                return jsInvocation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "receiver";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doApply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doApply";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF";
        objectArray[2] = "getIntrinsic";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF";
        objectArray[2] = "getIntrinsic";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class UnaryOperationInstrinsicBase
    extends FunctionIntrinsicWithReceiverComputed {
        private UnaryOperationInstrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull TranslationContext var2);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
            if (arguments2 == null) {
                UnaryOperationInstrinsicBase.$$$reportNull$$$1(0);
            }
            if (context2 == null) {
                UnaryOperationInstrinsicBase.$$$reportNull$$$1(1);
            }
            if (arguments2 == null) {
                UnaryOperationInstrinsicBase.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                UnaryOperationInstrinsicBase.$$$reportNull$$$0(1);
            }
            assert (receiver != null);
            assert (arguments2.size() == 0);
            JsExpression jsExpression = this.doApply(receiver, context2);
            if (jsExpression == null) {
                UnaryOperationInstrinsicBase.$$$reportNull$$$0(2);
            }
            if (jsExpression == null) {
                UnaryOperationInstrinsicBase.$$$reportNull$$$1(2);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ByteOverflowIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        private final FunctionIntrinsicWithReceiverComputed underlyingIntrinsic;

        public ByteOverflowIntrinsic(FunctionIntrinsicWithReceiverComputed underlyingIntrinsic) {
            this.underlyingIntrinsic = underlyingIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
            if (arguments2 == null) {
                ByteOverflowIntrinsic.$$$reportNull$$$1(0);
            }
            if (context2 == null) {
                ByteOverflowIntrinsic.$$$reportNull$$$1(1);
            }
            if (arguments2 == null) {
                ByteOverflowIntrinsic.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                ByteOverflowIntrinsic.$$$reportNull$$$0(1);
            }
            JsInvocation jsInvocation = AstUtilsKt.toByte(context2, this.underlyingIntrinsic.apply(receiver, arguments2, context2));
            if (jsInvocation == null) {
                ByteOverflowIntrinsic.$$$reportNull$$$0(2);
            }
            if (jsInvocation == null) {
                ByteOverflowIntrinsic.$$$reportNull$$$1(2);
            }
            return jsInvocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ByteOverflowIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ByteOverflowIntrinsic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ByteOverflowIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ByteOverflowIntrinsic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ShortOverflowIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        private final FunctionIntrinsicWithReceiverComputed underlyingIntrinsic;

        public ShortOverflowIntrinsic(FunctionIntrinsicWithReceiverComputed underlyingIntrinsic) {
            this.underlyingIntrinsic = underlyingIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
            if (arguments2 == null) {
                ShortOverflowIntrinsic.$$$reportNull$$$1(0);
            }
            if (context2 == null) {
                ShortOverflowIntrinsic.$$$reportNull$$$1(1);
            }
            if (arguments2 == null) {
                ShortOverflowIntrinsic.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                ShortOverflowIntrinsic.$$$reportNull$$$0(1);
            }
            JsInvocation jsInvocation = AstUtilsKt.toShort(context2, this.underlyingIntrinsic.apply(receiver, arguments2, context2));
            if (jsInvocation == null) {
                ShortOverflowIntrinsic.$$$reportNull$$$0(2);
            }
            if (jsInvocation == null) {
                ShortOverflowIntrinsic.$$$reportNull$$$1(2);
            }
            return jsInvocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ShortOverflowIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ShortOverflowIntrinsic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ShortOverflowIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$ShortOverflowIntrinsic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntOverflowIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        private final FunctionIntrinsicWithReceiverComputed underlyingIntrinsic;

        public IntOverflowIntrinsic(FunctionIntrinsicWithReceiverComputed underlyingIntrinsic) {
            this.underlyingIntrinsic = underlyingIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context2) {
            if (arguments2 == null) {
                IntOverflowIntrinsic.$$$reportNull$$$1(0);
            }
            if (context2 == null) {
                IntOverflowIntrinsic.$$$reportNull$$$1(1);
            }
            if (arguments2 == null) {
                IntOverflowIntrinsic.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                IntOverflowIntrinsic.$$$reportNull$$$0(1);
            }
            JsExpression jsExpression = JsAstUtils.toInt32(this.underlyingIntrinsic.apply(receiver, arguments2, context2));
            if (jsExpression == null) {
                IntOverflowIntrinsic.$$$reportNull$$$0(2);
            }
            if (jsExpression == null) {
                IntOverflowIntrinsic.$$$reportNull$$$1(2);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$IntOverflowIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$IntOverflowIntrinsic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$IntOverflowIntrinsic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$IntOverflowIntrinsic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

