/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.impl.OutputsCleaner;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;

public class RemovePreviousOutputsStep<C extends InputChangesContext, R extends Result>
implements Step<C, R> {
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super C, ? extends R> delegate;

    public RemovePreviousOutputsStep(Deleter deleter, OutputChangeListener outputChangeListener, Step<? super C, ? extends R> delegate) {
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        if (!context.isIncrementalExecution() && work.shouldCleanupOutputsOnNonIncrementalExecution()) {
            boolean hasOverlappingOutputs = context.getBeforeExecutionState().flatMap(BeforeExecutionState::getDetectedOverlappingOutputs).isPresent();
            if (hasOverlappingOutputs) {
                this.cleanupOverlappingOutputs((BeforeExecutionContext)context, work);
            } else {
                this.cleanupExclusivelyOwnedOutputs((BeforeExecutionContext)context, work);
            }
        }
        return this.delegate.execute(work, context);
    }

    private void cleanupOverlappingOutputs(BeforeExecutionContext context, UnitOfWork work) {
        context.getAfterPreviousExecutionState().ifPresent(previousOutputs -> {
            final HashSet outputDirectoriesToPreserve = new HashSet();
            work.visitOutputs(context.getWorkspace(), new UnitOfWork.OutputVisitor(){

                @Override
                public void visitOutputProperty(String propertyName, TreeType type, File root, FileCollection contents) {
                    switch (type) {
                        case FILE: {
                            File parentFile = root.getParentFile();
                            if (parentFile == null) break;
                            outputDirectoriesToPreserve.add(parentFile);
                            break;
                        }
                        case DIRECTORY: {
                            outputDirectoriesToPreserve.add(root);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            });
            OutputsCleaner cleaner = new OutputsCleaner(this.deleter, file -> true, dir -> !outputDirectoriesToPreserve.contains(dir));
            for (FileSystemSnapshot snapshot : previousOutputs.getOutputFilesProducedByWork().values()) {
                try {
                    this.outputChangeListener.beforeOutputChange(SnapshotUtil.rootIndex((FileSystemSnapshot)snapshot).keySet());
                    cleaner.cleanupOutputs(snapshot);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to clean up output files for " + work.getDisplayName(), e);
                }
            }
        });
    }

    private void cleanupExclusivelyOwnedOutputs(BeforeExecutionContext context, UnitOfWork work) {
        work.visitOutputs(context.getWorkspace(), new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, File root, FileCollection contents) {
                if (root.exists()) {
                    try {
                        switch (type) {
                            case FILE: {
                                RemovePreviousOutputsStep.this.deleter.delete(root);
                                break;
                            }
                            case DIRECTORY: {
                                RemovePreviousOutputsStep.this.deleter.ensureEmptyDirectory(root);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        });
    }
}

