/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.GUtil;

public class DefaultIvyArtifactName
implements IvyArtifactName {
    private final String name;
    private final String type;
    private final String extension;
    private final String classifier;
    private final int hashCode;

    public static DefaultIvyArtifactName forPublishArtifact(PublishArtifact publishArtifact) {
        String name = publishArtifact.getName();
        if (name == null) {
            name = publishArtifact.getFile().getName();
        }
        String classifier = (String)GUtil.elvis((Object)publishArtifact.getClassifier(), null);
        return new DefaultIvyArtifactName(name, publishArtifact.getType(), publishArtifact.getExtension(), classifier);
    }

    public static DefaultIvyArtifactName forFile(File file, @Nullable String classifier) {
        String fileName = file.getName();
        return DefaultIvyArtifactName.forFileName(fileName, classifier);
    }

    public static DefaultIvyArtifactName forFileName(String fileName, @Nullable String classifier) {
        String name = Files.getNameWithoutExtension((String)fileName);
        String extension = Files.getFileExtension((String)fileName);
        return new DefaultIvyArtifactName(name, extension, extension, classifier);
    }

    public DefaultIvyArtifactName(String name, String type, @Nullable String extension) {
        this(name, type, extension, null);
    }

    public DefaultIvyArtifactName(String name, String type, @Nullable String extension, @Nullable String classifier) {
        this.name = name;
        this.type = type;
        this.extension = extension;
        this.classifier = classifier;
        this.hashCode = this.computeHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        if (GUtil.isTrue((Object)this.classifier)) {
            result.append("-");
            result.append(this.classifier);
        }
        if (GUtil.isTrue((Object)this.extension) && !Files.getFileExtension((String)this.name).equals(this.extension)) {
            result.append(".");
            result.append(this.extension);
        }
        return result.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultIvyArtifactName other = (DefaultIvyArtifactName)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.extension, (Object)other.extension) && Objects.equal((Object)this.classifier, (Object)other.classifier);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }
}

