/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.DefaultPropertyTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH&J\"\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fH&J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0010H&J,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0015H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "Lorg/jetbrains/kotlin/js/translate/general/TranslatorVisitor;", "", "()V", "enumInitializerName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getEnumInitializerName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "addFunction", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psi", "Lorg/jetbrains/kotlin/psi/KtElement;", "addProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "emptyResult", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "getBackingFieldReference", "translateFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "data", "js.translator"})
public abstract class AbstractDeclarationVisitor
extends TranslatorVisitor<Unit> {
    @Override
    protected void emptyResult(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    @Nullable
    public JsName getEnumInitializerName() {
        return null;
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ClassTranslator.Companion.translate(classOrObject, context2, this.getEnumInitializerName());
        ClassDescriptor classDescriptor2 = BindingUtils.getClassDescriptor(context2.bindingContext(), classOrObject);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"BindingUtils.getClassDes\u2026Context(), classOrObject)");
        ClassDescriptor descriptor2 = classDescriptor2;
        context2.export(descriptor2);
    }

    @Override
    public void visitProperty(@NotNull KtProperty expression2, @NotNull TranslationContext context2) {
        JsExpression setterExpr;
        JsExpression jsExpression;
        JsExpression getterExpr;
        JsExpression jsExpression2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context2.bindingContext(), expression2);
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"BindingUtils.getProperty\u2026ingContext(), expression)");
        PropertyDescriptor descriptor2 = propertyDescriptor;
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return;
        }
        TranslationContext translationContext = context2.newDeclaration(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.newDeclaration(descriptor)");
        TranslationContext propertyContext = translationContext;
        DefaultPropertyTranslator defaultTranslator = new DefaultPropertyTranslator(descriptor2, context2, this.getBackingFieldReference(descriptor2));
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)propertyGetterDescriptor, (String)"descriptor.getter!!");
        PropertyGetterDescriptor getter2 = propertyGetterDescriptor;
        if (PropertyTranslatorKt.hasCustomGetter(expression2)) {
            FunctionDescriptor functionDescriptor = getter2;
            KtPropertyAccessor ktPropertyAccessor = expression2.getGetter();
            Intrinsics.checkNotNull((Object)ktPropertyAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)ktPropertyAccessor, (String)"expression.getter!!");
            jsExpression2 = (JsExpression)this.translateFunction(functionDescriptor, ktPropertyAccessor, propertyContext).getFirst();
        } else {
            JsFunction jsFunction = context2.getFunctionObject(getter2);
            Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"context.getFunctionObject(getter)");
            JsFunction function2 = jsFunction;
            function2.setSource(expression2);
            defaultTranslator.generateDefaultGetterFunction(getter2, function2);
            jsExpression2 = getterExpr = (JsExpression)function2;
        }
        if (descriptor2.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            Intrinsics.checkNotNull((Object)propertySetterDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)propertySetterDescriptor, (String)"descriptor.setter!!");
            PropertySetterDescriptor setter2 = propertySetterDescriptor;
            if (PropertyTranslatorKt.hasCustomSetter(expression2)) {
                FunctionDescriptor functionDescriptor = setter2;
                KtPropertyAccessor ktPropertyAccessor = expression2.getSetter();
                Intrinsics.checkNotNull((Object)ktPropertyAccessor);
                Intrinsics.checkNotNullExpressionValue((Object)ktPropertyAccessor, (String)"expression.setter!!");
                jsExpression = (JsExpression)this.translateFunction(functionDescriptor, ktPropertyAccessor, propertyContext).getFirst();
            } else {
                JsFunction jsFunction = context2.getFunctionObject(setter2);
                Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"context.getFunctionObject(setter)");
                JsFunction function3 = jsFunction;
                function3.setSource(expression2);
                defaultTranslator.generateDefaultSetterFunction(setter2, function3);
                jsExpression = function3;
            }
        } else {
            jsExpression = setterExpr = null;
        }
        if (TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)descriptor2) || DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
            PropertyGetterDescriptor propertyGetterDescriptor2 = descriptor2.getGetter();
            Intrinsics.checkNotNull((Object)propertyGetterDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)propertyGetterDescriptor2, (String)"descriptor.getter!!");
            KtPropertyAccessor ktPropertyAccessor = expression2.getGetter();
            this.addFunction(propertyGetterDescriptor2, getterExpr, ktPropertyAccessor != null ? (KtDeclaration)ktPropertyAccessor : (KtDeclaration)expression2);
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            if (propertySetterDescriptor != null) {
                PropertySetterDescriptor propertySetterDescriptor2 = propertySetterDescriptor;
                boolean bl = false;
                boolean bl2 = false;
                PropertySetterDescriptor it = propertySetterDescriptor2;
                boolean bl3 = false;
                PropertySetterDescriptor propertySetterDescriptor3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)propertySetterDescriptor3, (String)"it");
                FunctionDescriptor functionDescriptor = propertySetterDescriptor3;
                JsExpression jsExpression3 = setterExpr;
                Intrinsics.checkNotNull((Object)jsExpression3);
                KtPropertyAccessor ktPropertyAccessor2 = expression2.getSetter();
                this.addFunction(functionDescriptor, jsExpression3, ktPropertyAccessor2 != null ? (KtDeclaration)ktPropertyAccessor2 : (KtDeclaration)expression2);
            }
        } else {
            this.addProperty(descriptor2, getterExpr, setterExpr);
        }
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction expression2, @NotNull TranslationContext context2) {
        Pair<JsExpression, TranslationContext> functionAndContext;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(context2.bindingContext(), expression2);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"BindingUtils.getFunction\u2026ingContext(), expression)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        Pair<JsExpression, TranslationContext> pair = functionAndContext = descriptor2.getModality() != Modality.ABSTRACT ? this.translateFunction(descriptor2, expression2, context2) : null;
        this.addFunction(descriptor2, pair != null ? (JsExpression)pair.getFirst() : null, expression2);
    }

    @Override
    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable TranslationContext data) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
    }

    private final Pair<JsExpression, TranslationContext> translateFunction(FunctionDescriptor descriptor2, KtDeclarationWithBody expression2, TranslationContext context2) {
        JsFunction jsFunction = context2.getFunctionObject(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)jsFunction, (String)"context.getFunctionObject(descriptor)");
        JsFunction function2 = jsFunction;
        function2.setSource(expression2);
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"function.body");
        PsiElement psiElement = UtilsKt.getFinalElement(expression2);
        if (!(psiElement instanceof LeafPsiElement)) {
            psiElement = null;
        }
        jsBlock.setSource((LeafPsiElement)psiElement);
        TranslationContext translationContext = context2.newDeclaration(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context.newDeclaration(descriptor)");
        List<JsParameter> list2 = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"function.parameters");
        TranslationContext innerContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext, descriptor2, list2);
        if (descriptor2.isSuspend()) {
            UtilsKt.fillCoroutineMetadata(function2, innerContext, descriptor2, false);
        }
        if (!ModalityUtilsKt.isOverridable(descriptor2)) {
            JsBlock jsBlock2 = function2.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"function.body");
            Collection collection = jsBlock2.getStatements();
            List<JsStatement> list3 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, innerContext);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"FunctionBodyTranslator.s\u2026descriptor, innerContext)");
            Iterable iterable = list3;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        FunctionTranslatorKt.translateFunction(innerContext, expression2, function2);
        return new Pair((Object)FunctionTranslatorKt.wrapWithInlineMetadata(innerContext, context2, function2, descriptor2), (Object)innerContext);
    }

    public abstract void addFunction(@NotNull FunctionDescriptor var1, @Nullable JsExpression var2, @Nullable KtElement var3);

    public abstract void addProperty(@NotNull PropertyDescriptor var1, @NotNull JsExpression var2, @Nullable JsExpression var3);

    @NotNull
    public abstract JsExpression getBackingFieldReference(@NotNull PropertyDescriptor var1);
}

