/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.internal.GradleInternal;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.runner.AbstractClientProvidedBuildActionRunner;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class ClientProvidedBuildActionRunner
extends AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        if (!(action instanceof ClientProvidedBuildAction)) {
            return BuildActionRunner.Result.nothing();
        }
        GradleInternal gradle = buildController.getGradle();
        ClientProvidedBuildAction clientProvidedBuildAction = (ClientProvidedBuildAction)action;
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        Object clientAction = payloadSerializer.deserialize(clientProvidedBuildAction.getAction());
        return this.runClientAction(new ClientActionImpl(clientAction, action), buildController);
    }

    private PayloadSerializer getPayloadSerializer(GradleInternal gradle) {
        return (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
    }

    private static class ClientActionImpl
    implements AbstractClientProvidedBuildActionRunner.ClientAction {
        private final Object clientAction;
        private final BuildAction action;
        Object result;

        public ClientActionImpl(Object clientAction, BuildAction action) {
            this.clientAction = clientAction;
            this.action = action;
        }

        @Override
        public Object getProjectsEvaluatedAction() {
            return null;
        }

        @Override
        public Object getBuildFinishedAction() {
            return this.clientAction;
        }

        @Override
        public void collectActionResult(Object result, PhasedActionResult.Phase phase) {
            this.result = result;
        }

        @Override
        public boolean isRunTasks() {
            return this.action.isRunTasks();
        }

        @Override
        public Object getResult() {
            return this.result;
        }
    }
}

