/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.IntIntFunction;

public class ObjectUtils {
    public static final Object NULL = ObjectUtils.sentinel("ObjectUtils.NULL");

    @NotNull
    public static Object sentinel(@NotNull String name) {
        if (name == null) {
            ObjectUtils.$$$reportNull$$$0(0);
        }
        return new Sentinel(name);
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        return ObjectUtils.notNull(t);
    }

    public static <T> void assertAllElementsNotNull(@NotNull T[] array) {
        if (array == null) {
            ObjectUtils.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i + "] is null");
        }
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return ObjectUtils.chooseNotNull(t1, t2);
    }

    @NotNull
    public static <T> T notNull(@Nullable T value2) {
        return ObjectUtils.notNull(value2, value2);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T notNull(@Nullable T value2, @NotNull T defaultValue2) {
        if (defaultValue2 == null) {
            ObjectUtils.$$$reportNull$$$0(5);
        }
        T t = value2 == null ? defaultValue2 : value2;
        if (t == null) {
            ObjectUtils.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            ObjectUtils.$$$reportNull$$$0(9);
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    public static int binarySearch(int fromIndex, int toIndex, @NotNull IntIntFunction indexComparator) {
        if (indexComparator == null) {
            ObjectUtils.$$$reportNull$$$0(16);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = indexComparator.fun(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ofInterface";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ObjectUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ObjectUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sentinel";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sentinel";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertAllElementsNotNull";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doIfCast";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doIfNotNull";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "consumeIfNotNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "consumeIfCast";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nullizeByCondition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "nullizeIfDefaultValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "binarySearch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Sentinel {
        private final String myName;

        Sentinel(@NotNull String name) {
            if (name == null) {
                Sentinel.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/ObjectUtils$Sentinel", "<init>"));
        }
    }
}

