/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.AbstractCompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.PartialDirectorySnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.VfsRelativePath;

public class CompleteDirectorySnapshot
extends AbstractCompleteFileSystemLocationSnapshot {
    private final List<CompleteFileSystemLocationSnapshot> children;
    private final HashCode contentHash;

    public CompleteDirectorySnapshot(String absolutePath, String name, List<CompleteFileSystemLocationSnapshot> children, HashCode contentHash, FileMetadata.AccessType accessType) {
        super(absolutePath, name, accessType);
        this.children = children;
        this.contentHash = contentHash;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public FileType getType() {
        return FileType.Directory;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(CompleteFileSystemLocationSnapshot other) {
        return other instanceof CompleteDirectorySnapshot;
    }

    @Override
    public void accept(FileSystemSnapshotVisitor visitor) {
        if (!visitor.preVisitDirectory(this)) {
            return;
        }
        for (CompleteFileSystemLocationSnapshot child : this.children) {
            child.accept(visitor);
        }
        visitor.postVisitDirectory(this);
    }

    @VisibleForTesting
    public List<CompleteFileSystemLocationSnapshot> getChildren() {
        return this.children;
    }

    @Override
    protected Optional<MetadataSnapshot> getChildSnapshot(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return Optional.of(SnapshotUtil.getMetadataFromChildren(this.children, relativePath, caseSensitivity, Optional::empty).orElseGet(() -> CompleteDirectorySnapshot.missingSnapshotForAbsolutePath(relativePath.getAbsolutePath())));
    }

    @Override
    public Optional<FileSystemNode> invalidate(final VfsRelativePath relativePath, final CaseSensitivity caseSensitivity, final SnapshotHierarchy.NodeDiffListener diffListener) {
        return SnapshotUtil.handleChildren(this.children, relativePath, caseSensitivity, new SnapshotUtil.ChildHandler<Optional<FileSystemNode>>(){

            @Override
            public Optional<FileSystemNode> handleNewChild(int insertBefore) {
                diffListener.nodeRemoved(CompleteDirectorySnapshot.this);
                CompleteDirectorySnapshot.this.children.forEach(diffListener::nodeAdded);
                return Optional.of(new PartialDirectorySnapshot(CompleteDirectorySnapshot.this.getPathToParent(), CompleteDirectorySnapshot.this.children));
            }

            @Override
            public Optional<FileSystemNode> handleChildOfExisting(int childIndex) {
                diffListener.nodeRemoved(CompleteDirectorySnapshot.this);
                CompleteFileSystemLocationSnapshot foundChild = (CompleteFileSystemLocationSnapshot)CompleteDirectorySnapshot.this.children.get(childIndex);
                int childPathLength = foundChild.getPathToParent().length();
                boolean completeChildRemoved = childPathLength == relativePath.length();
                Optional<FileSystemNode> invalidated = completeChildRemoved ? Optional.empty() : foundChild.invalidate(relativePath.suffixStartingFrom(childPathLength + 1), caseSensitivity, new SnapshotHierarchy.NodeDiffListener(){

                    @Override
                    public void nodeRemoved(FileSystemNode node) {
                    }

                    @Override
                    public void nodeAdded(FileSystemNode node) {
                        diffListener.nodeAdded(node);
                    }
                });
                CompleteDirectorySnapshot.this.children.forEach(child -> {
                    if (child != foundChild) {
                        diffListener.nodeAdded((FileSystemNode)child);
                    }
                });
                return Optional.of(new PartialDirectorySnapshot(CompleteDirectorySnapshot.this.getPathToParent(), this.getChildren(childIndex, invalidated)));
            }

            private List<FileSystemNode> getChildren(int childIndex, Optional<FileSystemNode> invalidated) {
                if (CompleteDirectorySnapshot.this.children.size() == 1) {
                    return (List)invalidated.map(ImmutableList::of).orElseGet(ImmutableList::of);
                }
                return invalidated.map(invalidatedChild -> {
                    ArrayList<FileSystemNode> newChildren = new ArrayList<FileSystemNode>(CompleteDirectorySnapshot.this.children);
                    newChildren.set(childIndex, (FileSystemNode)invalidatedChild);
                    return newChildren;
                }).orElseGet(() -> {
                    if (CompleteDirectorySnapshot.this.children.size() == 2) {
                        CompleteFileSystemLocationSnapshot singleChild = childIndex == 0 ? (CompleteFileSystemLocationSnapshot)CompleteDirectorySnapshot.this.children.get(1) : (CompleteFileSystemLocationSnapshot)CompleteDirectorySnapshot.this.children.get(0);
                        return ImmutableList.of((Object)singleChild);
                    }
                    ArrayList newChildren = new ArrayList(CompleteDirectorySnapshot.this.children);
                    newChildren.remove(childIndex);
                    return newChildren;
                });
            }
        });
    }
}

