/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.gradle.api.internal.artifacts.verification.signatures.CrossBuildCachingKeyService;
import org.gradle.api.internal.artifacts.verification.signatures.CrossBuildSignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationResultBuilder;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transport.http.HttpConnectorFactory;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.KeyringFilePublicKeyService;
import org.gradle.security.internal.PublicKeyDownloadService;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.PublicKeyServiceChain;
import org.gradle.security.internal.SecuritySupport;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultSignatureVerificationServiceFactory
implements SignatureVerificationServiceFactory {
    private final HttpConnectorFactory httpConnectorFactory;
    private final CacheRepository cacheRepository;
    private final InMemoryCacheDecoratorFactory decoratorFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final FileHasher fileHasher;
    private final CacheScopeMapping scopeCacheMapping;
    private final ProjectCacheDir projectCacheDir;
    private final BuildCommencedTimeProvider timeProvider;
    private final boolean refreshKeys;

    public DefaultSignatureVerificationServiceFactory(HttpConnectorFactory httpConnectorFactory, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory decoratorFactory, BuildOperationExecutor buildOperationExecutor, FileHasher fileHasher, CacheScopeMapping scopeCacheMapping, ProjectCacheDir projectCacheDir, BuildCommencedTimeProvider timeProvider, boolean refreshKeys) {
        this.httpConnectorFactory = httpConnectorFactory;
        this.cacheRepository = cacheRepository;
        this.decoratorFactory = decoratorFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.fileHasher = fileHasher;
        this.scopeCacheMapping = scopeCacheMapping;
        this.projectCacheDir = projectCacheDir;
        this.timeProvider = timeProvider;
        this.refreshKeys = refreshKeys;
    }

    @Override
    public SignatureVerificationService create(File keyringsFile, List<URI> keyServers) {
        ExternalResourceConnector connector = this.httpConnectorFactory.createResourceConnector(new ResourceConnectorSpecification(){});
        PublicKeyDownloadService keyDownloadService = new PublicKeyDownloadService((List)ImmutableList.copyOf(keyServers), (ExternalResourceAccessor)connector);
        CrossBuildCachingKeyService keyService = new CrossBuildCachingKeyService(this.cacheRepository, this.decoratorFactory, this.buildOperationExecutor, (PublicKeyService)keyDownloadService, this.timeProvider, this.refreshKeys);
        if (keyringsFile.exists()) {
            KeyringFilePublicKeyService keyringFilePublicKeyService = new KeyringFilePublicKeyService(keyringsFile);
            keyService = PublicKeyServiceChain.of((PublicKeyService[])new PublicKeyService[]{keyringFilePublicKeyService, keyService});
        }
        DefaultSignatureVerificationService delegate = new DefaultSignatureVerificationService(keyService);
        return new CrossBuildSignatureVerificationService(delegate, this.fileHasher, this.scopeCacheMapping, this.projectCacheDir, this.cacheRepository, this.decoratorFactory, this.timeProvider, this.refreshKeys);
    }

    private static class DefaultSignatureVerificationService
    implements SignatureVerificationService {
        private final PublicKeyService keyService;

        public DefaultSignatureVerificationService(PublicKeyService keyService) {
            this.keyService = keyService;
        }

        @Override
        public void verify(final File origin, File signature, final Set<String> trustedKeys, final Set<String> ignoredKeys, final SignatureVerificationResultBuilder result) {
            PGPSignatureList pgpSignatures = SecuritySupport.readSignatures((File)signature);
            for (final PGPSignature pgpSignature : pgpSignatures) {
                String longIdKey = SecuritySupport.toLongIdHexString((long)pgpSignature.getKeyID());
                if (ignoredKeys.contains(longIdKey)) {
                    result.ignored(longIdKey);
                    continue;
                }
                final AtomicBoolean missing = new AtomicBoolean(true);
                this.keyService.findByLongId(pgpSignature.getKeyID(), new PublicKeyResultBuilder(){

                    public void keyRing(PGPPublicKeyRing keyring) {
                    }

                    public void publicKey(PGPPublicKey pgpPublicKey) {
                        missing.set(false);
                        String fingerprint = Fingerprint.of((PGPPublicKey)pgpPublicKey).toString();
                        if (ignoredKeys.contains(fingerprint)) {
                            result.ignored(fingerprint);
                            return;
                        }
                        try {
                            boolean verified = SecuritySupport.verify((File)origin, (PGPSignature)pgpSignature, (PGPPublicKey)pgpPublicKey);
                            if (!verified) {
                                result.failed(pgpPublicKey);
                            } else {
                                boolean trusted = trustedKeys.contains(fingerprint) || trustedKeys.contains(SecuritySupport.toLongIdHexString((long)pgpPublicKey.getKeyID()));
                                result.verified(pgpPublicKey, trusted);
                            }
                        }
                        catch (PGPException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e);
                        }
                    }
                });
                if (!missing.get()) continue;
                result.missingKey(longIdKey);
            }
        }

        @Override
        public PublicKeyService getPublicKeyService() {
            return this.keyService;
        }

        public void stop() {
            try {
                this.keyService.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

