/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.initialization.SessionLifecycleListener;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.event.ListenerManager;

@ThreadSafe
public class DefaultCrossBuildInMemoryCacheFactory
implements CrossBuildInMemoryCacheFactory {
    private final ListenerManager listenerManager;

    public DefaultCrossBuildInMemoryCacheFactory(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public <K, V> CrossBuildInMemoryCache<K, V> newCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(new HashMap());
        this.listenerManager.addListener(cache);
        return cache;
    }

    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassCache() {
        DefaultCrossBuildInMemoryCache cache = new DefaultCrossBuildInMemoryCache(new WeakHashMap());
        this.listenerManager.addListener(cache);
        return cache;
    }

    public <V> CrossBuildInMemoryCache<Class<?>, V> newClassMap() {
        DefaultClassMap map = new DefaultClassMap();
        this.listenerManager.addListener(map);
        return map;
    }

    private static class DefaultClassMap<V>
    extends AbstractCrossBuildInMemoryCache<Class<?>, V> {
        private final Map<Class<?>, V> leakyValues = new HashMap();

        private DefaultClassMap() {
        }

        @Override
        protected void retainValuesFromCurrentSession(Collection<V> values) {
        }

        @Override
        protected void discardRetainedValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void retainValue(Class<?> key, V v) {
            this.getCacheScope(key).put(key, v);
        }

        @Override
        @Nullable
        protected V maybeGetRetainedValue(Class<?> key) {
            return this.getCacheScope(key).get(key);
        }

        private Map<Class<?>, V> getCacheScope(Class<?> type) {
            ClassLoader classLoader = type.getClassLoader();
            if (classLoader instanceof VisitableURLClassLoader) {
                return (Map)((VisitableURLClassLoader)classLoader).getUserData((Object)this, new Factory<Map<Class<?>, V>>(){

                    public Map<Class<?>, V> create() {
                        return new HashMap();
                    }
                });
            }
            return this.leakyValues;
        }
    }

    private static class DefaultCrossBuildInMemoryCache<K, V>
    extends AbstractCrossBuildInMemoryCache<K, V> {
        private final Set<V> valuesForPreviousSession = new HashSet<V>();
        private final Map<K, SoftReference<V>> allValues;

        public DefaultCrossBuildInMemoryCache(Map<K, SoftReference<V>> allValues) {
            this.allValues = allValues;
        }

        @Override
        protected void retainValuesFromCurrentSession(Collection<V> values) {
            this.valuesForPreviousSession.clear();
            this.valuesForPreviousSession.addAll(values);
        }

        @Override
        protected void discardRetainedValues() {
            this.valuesForPreviousSession.clear();
            this.allValues.clear();
        }

        @Override
        protected void retainValue(K key, V v) {
            this.allValues.put(key, new SoftReference<V>(v));
        }

        @Override
        @Nullable
        protected V maybeGetRetainedValue(K key) {
            SoftReference<V> reference = this.allValues.get(key);
            if (reference != null) {
                return reference.get();
            }
            return null;
        }
    }

    private static abstract class AbstractCrossBuildInMemoryCache<K, V>
    implements CrossBuildInMemoryCache<K, V>,
    SessionLifecycleListener {
        private final Object lock = new Object();
        private final Map<K, V> valuesForThisSession = new HashMap();

        private AbstractCrossBuildInMemoryCache() {
        }

        @Override
        public void afterStart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeComplete() {
            Object object = this.lock;
            synchronized (object) {
                this.retainValuesFromCurrentSession(this.valuesForThisSession.values());
                this.valuesForThisSession.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.valuesForThisSession.clear();
                this.discardRetainedValues();
            }
        }

        protected abstract void retainValuesFromCurrentSession(Collection<V> var1);

        protected abstract void discardRetainedValues();

        protected abstract void retainValue(K var1, V var2);

        @Nullable
        protected abstract V maybeGetRetainedValue(K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public V get(K key) {
            Object object = this.lock;
            synchronized (object) {
                return this.getIfPresent(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key, Transformer<V, K> factory) {
            Object object = this.lock;
            synchronized (object) {
                Object v = this.getIfPresent(key);
                if (v != null) {
                    return v;
                }
                v = factory.transform(key);
                this.retainValue(key, v);
                this.valuesForThisSession.put(key, v);
                return v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                this.retainValue(key, value);
                this.valuesForThisSession.put(key, value);
            }
        }

        private V getIfPresent(K key) {
            V v = this.valuesForThisSession.get(key);
            if (v != null) {
                return v;
            }
            v = this.maybeGetRetainedValue(key);
            if (v != null) {
                this.valuesForThisSession.put(key, v);
                return v;
            }
            return null;
        }
    }
}

