/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.collect.AbstractIterator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class Instrumented {
    private static final Listener NO_OP = (key, value, consumer) -> {};
    private static final AtomicReference<Listener> LISTENER = new AtomicReference<Listener>(NO_OP);

    public static void setListener(Listener listener) {
        LISTENER.set(listener);
    }

    public static void discardListener() {
        LISTENER.set(NO_OP);
    }

    public static void groovyCallSites(CallSiteArray array) {
        for (CallSite callSite : array.array) {
            if (callSite.getName().equals("getProperty")) {
                array.array[callSite.getIndex()] = new SystemPropertyCallSite(callSite);
                continue;
            }
            if (callSite.getName().equals("properties")) {
                array.array[callSite.getIndex()] = new SystemPropertiesCallSite(callSite);
                continue;
            }
            if (callSite.getName().equals("getInteger")) {
                array.array[callSite.getIndex()] = new IntegerSystemPropertyCallSite(callSite);
                continue;
            }
            if (callSite.getName().equals("getLong")) {
                array.array[callSite.getIndex()] = new LongSystemPropertyCallSite(callSite);
                continue;
            }
            if (!callSite.getName().equals("getBoolean")) continue;
            array.array[callSite.getIndex()] = new BooleanSystemPropertyCallSite(callSite);
        }
    }

    public static String systemProperty(String key, String consumer) {
        return Instrumented.systemProperty(key, null, consumer);
    }

    public static String systemProperty(String key, @Nullable String defaultValue, String consumer) {
        String value = System.getProperty(key);
        LISTENER.get().systemPropertyQueried(key, value, consumer);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Properties systemProperties(String consumer) {
        return new DecoratingProperties(System.getProperties(), consumer);
    }

    public static Integer getInteger(String key, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Integer.getInteger(key);
    }

    public static Integer getInteger(String key, int defaultValue, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Long getLong(String key, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Long.getLong(key);
    }

    public static Long getLong(String key, long defaultValue, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Long.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Long.getLong(key, defaultValue);
    }

    public static boolean getBoolean(String key, String consumer) {
        LISTENER.get().systemPropertyQueried(key, System.getProperty(key), consumer);
        return Boolean.getBoolean(key);
    }

    private static Object unwrap(Object obj) {
        if (obj instanceof Wrapper) {
            return ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    private static class SystemPropertiesCallSite
    extends AbstractCallSite {
        public SystemPropertiesCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object callGetProperty(Object receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperties(this.array.owner.getName());
            }
            return super.callGetProperty(receiver);
        }
    }

    private static class SystemPropertyCallSite
    extends AbstractCallSite {
        public SystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty((String)arg, this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty((String)arg1, (String)arg2, this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    private static class BooleanSystemPropertyCallSite
    extends AbstractCallSite {
        public BooleanSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Boolean.class)) {
                return Instrumented.getBoolean((String)arg, this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }
    }

    private static class LongSystemPropertyCallSite
    extends AbstractCallSite {
        public LongSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Long.class)) {
                return Instrumented.getLong((String)arg, this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(Long.class)) {
                return Instrumented.getLong((String)arg1, (Long)Instrumented.unwrap(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    private static class IntegerSystemPropertyCallSite
    extends AbstractCallSite {
        public IntegerSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Integer.class)) {
                return Instrumented.getInteger((String)arg, this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(Integer.class)) {
                return Instrumented.getInteger((String)arg1, (Integer)Instrumented.unwrap(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    private static class DecoratingEntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        private final Set<Map.Entry<Object, Object>> delegate;
        private final String consumer;

        public DecoratingEntrySet(Set<Map.Entry<Object, Object>> delegate, String consumer) {
            this.delegate = delegate;
            this.consumer = consumer;
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            final Iterator<Map.Entry<Object, Object>> iterator = this.delegate.iterator();
            return new AbstractIterator<Map.Entry<Object, Object>>(){

                protected Map.Entry<Object, Object> computeNext() {
                    if (!iterator.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    Map.Entry entry = (Map.Entry)iterator.next();
                    ((Listener)LISTENER.get()).systemPropertyQueried((String)entry.getKey(), entry.getValue(), consumer);
                    return entry;
                }
            };
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }

    private static class DecoratingProperties
    extends Properties {
        private final String consumer;
        private final Properties delegate;

        public DecoratingProperties(Properties delegate, String consumer) {
            this.consumer = consumer;
            this.delegate = delegate;
        }

        @Override
        public Enumeration<?> propertyNames() {
            return this.delegate.propertyNames();
        }

        @Override
        public Set<String> stringPropertyNames() {
            return this.delegate.stringPropertyNames();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Enumeration<Object> keys() {
            return this.delegate.keys();
        }

        @Override
        public Enumeration<Object> elements() {
            return this.delegate.elements();
        }

        @Override
        public Set<Object> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new DecoratingEntrySet(this.delegate.entrySet(), this.consumer);
        }

        @Override
        public void forEach(BiConsumer<? super Object, ? super Object> action) {
            this.delegate.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                ((Listener)LISTENER.get()).systemPropertyQueried((String)k, v, this.consumer);
                action.accept(k, v);
            }));
        }

        @Override
        public void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
            this.delegate.replaceAll(function);
        }

        @Override
        public Object putIfAbsent(Object key, Object value) {
            return this.delegate.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        @Override
        public boolean replace(Object key, Object oldValue, Object newValue) {
            return this.delegate.replace(key, oldValue, newValue);
        }

        @Override
        public Object replace(Object key, Object value) {
            return this.delegate.replace(key, value);
        }

        @Override
        public Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
            return this.delegate.computeIfAbsent(key, mappingFunction);
        }

        @Override
        public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            return this.delegate.computeIfPresent(key, remappingFunction);
        }

        @Override
        public Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            return this.delegate.compute(key, remappingFunction);
        }

        @Override
        public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            return this.delegate.merge(key, value, remappingFunction);
        }

        @Override
        public boolean contains(Object value) {
            return this.delegate.contains(value);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.delegate.put(key, value);
        }

        @Override
        public Object setProperty(String key, String value) {
            return this.delegate.setProperty(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<?, ?> t) {
            this.delegate.putAll(t);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public String getProperty(String key) {
            return this.getProperty(key, null);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            String value = this.delegate.getProperty(key);
            ((Listener)LISTENER.get()).systemPropertyQueried(key, value, this.consumer);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public Object getOrDefault(Object key, Object defaultValue) {
            return this.getProperty((String)key, (String)defaultValue);
        }

        @Override
        public Object get(Object key) {
            return this.getProperty((String)key);
        }
    }

    public static interface Listener {
        public void systemPropertyQueried(String var1, @Nullable Object var2, String var3);
    }
}

