/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.vfs.AdditiveCacheLocations;

public class SplitResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private final ResourceSnapshotterCacheService globalCache;
    private final ResourceSnapshotterCacheService localCache;
    private final AdditiveCacheLocations additiveCacheLocations;

    public SplitResourceSnapshotterCacheService(ResourceSnapshotterCacheService globalCache, ResourceSnapshotterCacheService localCache, AdditiveCacheLocations additiveCacheLocations) {
        this.globalCache = globalCache;
        this.localCache = localCache;
        this.additiveCacheLocations = additiveCacheLocations;
    }

    @Override
    public HashCode hashFile(RegularFileSnapshot fileSnapshot, RegularFileHasher hasher, HashCode configurationHash) {
        if (this.additiveCacheLocations.isInsideAdditiveCache(fileSnapshot.getAbsolutePath())) {
            return this.globalCache.hashFile(fileSnapshot, hasher, configurationHash);
        }
        return this.localCache.hashFile(fileSnapshot, hasher, configurationHash);
    }
}

