/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.vfs.AbstractEventDrivenFileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHierarchicalFileWatcherRegistry
extends AbstractEventDrivenFileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHierarchicalFileWatcherRegistry.class);
    private final Map<String, ImmutableList<Path>> watchedRootsForSnapshot = new HashMap<String, ImmutableList<Path>>();
    private final Multiset<Path> shouldWatchDirectories = HashMultiset.create();
    private final Set<Path> watchedRoots = new HashSet<Path>();
    private final Set<Path> mustWatchDirectories = new HashSet<Path>();

    public AbstractHierarchicalFileWatcherRegistry(AbstractEventDrivenFileWatcherRegistry.FileWatcherCreator watcherCreator, FileWatcherRegistry.ChangeHandler handler) {
        super(watcherCreator, handler);
    }

    public void changed(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots) {
        removedSnapshots.forEach(snapshot -> {
            ImmutableList<Path> previouslyWatchedRootsForSnapshot = this.watchedRootsForSnapshot.remove(snapshot.getAbsolutePath());
            Multisets.removeOccurrences(this.shouldWatchDirectories, previouslyWatchedRootsForSnapshot);
        });
        addedSnapshots.forEach(snapshot -> {
            ImmutableList directoriesToWatch = WatchRootUtil.getDirectoriesToWatch((CompleteFileSystemLocationSnapshot)snapshot);
            this.shouldWatchDirectories.addAll((Collection)directoriesToWatch);
            this.watchedRootsForSnapshot.put(snapshot.getAbsolutePath(), (ImmutableList<Path>)directoriesToWatch);
        });
        this.updateWatchedDirectories();
    }

    public void updateMustWatchDirectories(Collection<File> updatedWatchDirectories) {
        Set rootPaths = updatedWatchDirectories.stream().filter(File::isDirectory).map(File::toPath).map(Path::toAbsolutePath).collect(Collectors.toSet());
        Multisets.removeOccurrences(this.shouldWatchDirectories, this.mustWatchDirectories);
        this.mustWatchDirectories.clear();
        this.mustWatchDirectories.addAll(WatchRootUtil.resolveRootsToWatch(rootPaths));
        this.shouldWatchDirectories.addAll(this.mustWatchDirectories);
        this.updateWatchedDirectories();
    }

    private void updateWatchedDirectories() {
        ImmutableSet mustWatchDirectoryPrefixes = ImmutableSet.copyOf(this.mustWatchDirectories.stream().map(path -> path.toString() + File.separator)::iterator);
        Set directoriesToWatch = this.shouldWatchDirectories.elementSet().stream().filter(arg_0 -> AbstractHierarchicalFileWatcherRegistry.lambda$updateWatchedDirectories$3((Set)mustWatchDirectoryPrefixes, arg_0)).collect(Collectors.toSet());
        directoriesToWatch.addAll(this.mustWatchDirectories);
        this.updateWatchedDirectories(WatchRootUtil.resolveRootsToWatch(directoriesToWatch));
    }

    private void updateWatchedDirectories(Set<Path> newWatchRoots) {
        HashSet<Path> watchRootsToRemove = new HashSet<Path>(this.watchedRoots);
        if (newWatchRoots.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        watchRootsToRemove.removeAll(newWatchRoots);
        newWatchRoots.removeAll(this.watchedRoots);
        if (newWatchRoots.isEmpty() && watchRootsToRemove.isEmpty()) {
            return;
        }
        LOGGER.info("Watching {} directory hierarchies to track changes", (Object)newWatchRoots.size());
        this.getWatcher().startWatching((Collection)newWatchRoots.stream().map(Path::toFile).collect(Collectors.toList()));
        this.getWatcher().stopWatching((Collection)watchRootsToRemove.stream().map(Path::toFile).collect(Collectors.toList()));
        this.watchedRoots.addAll(newWatchRoots);
        this.watchedRoots.removeAll(watchRootsToRemove);
    }

    private static boolean startsWithAnyPrefix(String path, Set<String> prefixes) {
        for (String prefix : prefixes) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$updateWatchedDirectories$3(Set mustWatchDirectoryPrefixes, Path path) {
        return !AbstractHierarchicalFileWatcherRegistry.startsWithAnyPrefix(path.toString(), mustWatchDirectoryPrefixes);
    }
}

