/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleDescriptorHashModuleSource;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.InMemoryCacheController;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.resolve.caching.CrossBuildCachingRuleExecutor;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.util.BuildCommencedTimeProvider;

public class ComponentMetadataRuleExecutor
extends CrossBuildCachingRuleExecutor<ModuleComponentResolveMetadata, ComponentMetadataContext, ModuleComponentResolveMetadata> {
    private static final String CACHE_ID = "md-rule";
    private final Serializer<ModuleComponentResolveMetadata> componentMetadataContextSerializer;

    public static boolean isMetadataRuleExecutorCache(InMemoryCacheController controller) {
        return CACHE_ID.equals(controller.getCacheId());
    }

    private static Transformer<Object, ModuleComponentResolveMetadata> getKeyToSnapshotableTransformer() {
        return moduleMetadata -> moduleMetadata.getSources().withSource(ModuleDescriptorHashModuleSource.class, source -> source.map(metadataFileSource -> metadataFileSource.getDescriptorHash().toString()).orElseThrow(() -> new RuntimeException("Cannot find original content hash")));
    }

    public ComponentMetadataRuleExecutor(CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory, ValueSnapshotter snapshotter, BuildCommencedTimeProvider timeProvider, Serializer<ModuleComponentResolveMetadata> componentMetadataContextSerializer) {
        super(CACHE_ID, cacheRepository, cacheDecoratorFactory, snapshotter, timeProvider, ComponentMetadataRuleExecutor.createValidator(timeProvider), ComponentMetadataRuleExecutor.getKeyToSnapshotableTransformer(), componentMetadataContextSerializer);
        this.componentMetadataContextSerializer = componentMetadataContextSerializer;
    }

    public Serializer<ModuleComponentResolveMetadata> getComponentMetadataContextSerializer() {
        return this.componentMetadataContextSerializer;
    }

    private static CrossBuildCachingRuleExecutor.EntryValidator<ModuleComponentResolveMetadata> createValidator(BuildCommencedTimeProvider timeProvider) {
        return (policy, entry) -> {
            long age = timeProvider.getCurrentTime() - entry.getTimestamp();
            ModuleComponentResolveMetadata result = (ModuleComponentResolveMetadata)entry.getResult();
            boolean mustRefreshModule = policy.mustRefreshModule(new SimpleResolvedModuleVersion(result.getModuleVersionId()), age, result.isChanging());
            return !mustRefreshModule;
        };
    }

    private static class SimpleResolvedModuleVersion
    implements ResolvedModuleVersion {
        private final ModuleVersionIdentifier identifier;

        private SimpleResolvedModuleVersion(ModuleVersionIdentifier identifier) {
            this.identifier = identifier;
        }

        public ModuleVersionIdentifier getId() {
            return this.identifier;
        }
    }
}

