/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ExpressionHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.matchers.IrCallMatcher;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrBackendUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/DefaultIterableHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ExpressionHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "iterableClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getIterableClassSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "matchIterable", "", "ir.backend.common"})
public class DefaultIterableHandler
implements ExpressionHandler {
    @NotNull
    private final IrClassSymbol iterableClassSymbol;
    private final CommonBackendContext context;

    @NotNull
    protected IrClassSymbol getIterableClassSymbol() {
        return this.iterableClassSymbol;
    }

    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return IrTypeUtilsKt.isSubtypeOfClass(expression2.getType(), this.getIterableClassSymbol());
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = declarationIrBuilder;
        boolean bl3 = false;
        IrClassSymbol irClassSymbol = this.getIterableClassSymbol();
        String string2 = OperatorNameConventions.ITERATOR.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"OperatorNameConventions.ITERATOR.asString()");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = IrBackendUtilsKt.getSimpleFunction(irClassSymbol, string2);
        if (irSimpleFunctionSymbol == null) {
            Intrinsics.throwNpe();
        }
        IrSimpleFunction iteratorFun = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$with, iteratorFun);
        Scope scope2 = $this$with.getScope();
        boolean bl4 = false;
        boolean bl5 = false;
        IrFunctionAccessExpression $this$apply = irFunctionAccessExpression;
        boolean bl6 = false;
        $this$apply.setDispatchReceiver(expression2);
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression;
        IrVariable irVariable2 = IrBuildersKt.createTmpVariable$default(scope2, (IrExpression)irFunctionAccessExpression2, "iterator", false, null, null, 28, null);
        return new IterableHeaderInfo(irVariable2);
    }

    public DefaultIterableHandler(@NotNull CommonBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        this.iterableClassSymbol = this.context.getIr().getSymbols().getIterable();
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)scopeOwner, (String)"scopeOwner");
        return ExpressionHandler.DefaultImpls.build(this, expression2, data, scopeOwner);
    }

    @Override
    @Nullable
    public IrCallMatcher getIteratorCallMatcher() {
        return ExpressionHandler.DefaultImpls.getIteratorCallMatcher(this);
    }

    @Nullable
    public HeaderInfo handle(@NotNull IrExpression expression2, @Nullable IrCall iteratorCall, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)scopeOwner, (String)"scopeOwner");
        return ExpressionHandler.DefaultImpls.handle(this, expression2, iteratorCall, data, scopeOwner);
    }
}

