/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public class LanguageSpecificAdaptor
implements ProjectGenerator {
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final FileCollectionFactory fileCollectionFactory;
    private final TemplateOperationFactory templateOperationFactory;
    private final LanguageSpecificProjectGenerator descriptor;

    public LanguageSpecificAdaptor(LanguageSpecificProjectGenerator descriptor, BuildScriptBuilderFactory scriptBuilderFactory, FileCollectionFactory fileCollectionFactory, TemplateOperationFactory templateOperationFactory) {
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.descriptor = descriptor;
        this.fileCollectionFactory = fileCollectionFactory;
        this.templateOperationFactory = templateOperationFactory;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public ComponentType getComponentType() {
        return this.descriptor.getComponentType();
    }

    @Override
    public Language getLanguage() {
        return this.descriptor.getLanguage();
    }

    @Override
    public Optional<String> getFurtherReading() {
        return this.descriptor.getFurtherReading();
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        if (this.descriptor.getLanguage().equals(Language.KOTLIN)) {
            return BuildInitDsl.KOTLIN;
        }
        return BuildInitDsl.GROOVY;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return this.descriptor.getTestFrameworks();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return this.descriptor.getDefaultTestFramework();
    }

    @Override
    public boolean supportsPackage() {
        return this.descriptor.supportsPackage();
    }

    @Override
    public void generate(InitSettings settings) {
        BuildScriptBuilder buildScriptBuilder = this.scriptBuilderFactory.script(settings.getDsl(), "build");
        this.descriptor.generate(settings, buildScriptBuilder, new TemplateFactory(settings, this.descriptor.getLanguage(), this.fileCollectionFactory, this.templateOperationFactory));
        buildScriptBuilder.create().generate();
    }
}

