/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLogger {
    private static Logger LOGGER;

    public static void initLogging(Class<?> loggerClass) {
        Logger logger = Logger.getLogger(loggerClass.getName());
        Level effectiveLevel = Level.FINEST;
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.getLevel().equals(effectiveLevel)) continue;
            LOGGER = logger;
            NativeLogger.initLogging(logLevel.ordinal());
            return;
        }
        throw new AssertionError((Object)("Invalid log level for " + loggerClass + ": " + effectiveLevel));
    }

    private static Level getEffectiveLevel(Logger logger) {
        Level effectiveLevel;
        Logger effectiveLogger = logger;
        while ((effectiveLevel = effectiveLogger.getLevel()) == null) {
            if ((effectiveLogger = effectiveLogger.getParent()) == null) {
                throw new AssertionError((Object)"Effective log level is not set");
            }
        }
        return effectiveLevel;
    }

    private static native void initLogging(int var0);

    public static void log(int level, String message) {
        LOGGER.log(LogLevel.values()[level].getLevel(), message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LogLevel {
        FINEST(Level.FINEST),
        FINER(Level.FINER),
        FINE(Level.FINE),
        CONFIG(Level.CONFIG),
        INFO(Level.INFO),
        WARNING(Level.WARNING),
        SEVERE(Level.SEVERE);

        private final Level delegate;

        private LogLevel(Level delegate) {
            this.delegate = delegate;
        }

        Level getLevel() {
            return this.delegate;
        }
    }
}

