/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import gnu.trove.TIntHashSet;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.DataInputOutputUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringHash;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.BloomFilterBase;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.IntObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;

public class ClasspathCache {
    private final IntObjectHashMap myResourcePackagesCache = new IntObjectHashMap();
    private final IntObjectHashMap myClassPackagesCache = new IntObjectHashMap();
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLoaderData(LoaderData loaderData, Loader loader) {
        this.myLock.writeLock().lock();
        try {
            for (int resourcePackageHash : loaderData.myResourcePackageHashes) {
                ClasspathCache.addResourceEntry(resourcePackageHash, this.myResourcePackagesCache, loader);
            }
            for (int classPackageHash : loaderData.myClassPackageHashes) {
                ClasspathCache.addResourceEntry(classPackageHash, this.myClassPackagesCache, loader);
            }
            loader.applyData(loaderData);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <ResultType, ParameterType, ParameterType2> ResultType iterateLoaders(String resourcePath, LoaderIterator<ResultType, ParameterType, ParameterType2> iterator2, ParameterType parameter, ParameterType2 parameter2, String shortName) {
        Loader[] loaders;
        Object o;
        this.myLock.readLock().lock();
        try {
            IntObjectHashMap map2 = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
            o = map2.get(ClasspathCache.getPackageNameHash(resourcePath));
        }
        finally {
            this.myLock.readLock().unlock();
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Loader) {
            return iterator2.process((Loader)o, parameter, parameter2, shortName);
        }
        for (Loader l : loaders = (Loader[])o) {
            ResultType result2 = iterator2.process(l, parameter, parameter2, shortName);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    static int getPackageNameHash(String resourcePath) {
        int idx = resourcePath.lastIndexOf(47);
        int h = 0;
        for (int off = 0; off < idx; ++off) {
            h = 31 * h + resourcePath.charAt(off);
        }
        return h;
    }

    private static void addResourceEntry(int hash, IntObjectHashMap map2, Loader loader) {
        Object o = map2.get(hash);
        if (o == null) {
            map2.put(hash, loader);
        } else if (o instanceof Loader) {
            if (ClassPath.ourLogTiming) assert (loader != o);
            map2.put(hash, new Loader[]{(Loader)o, loader});
        } else {
            Loader[] loadersArray = (Loader[])o;
            if (ClassPath.ourLogTiming) assert (ArrayUtilRt.find(loadersArray, loader) == -1);
            Loader[] newArray = new Loader[loadersArray.length + 1];
            System.arraycopy(loadersArray, 0, newArray, 0, loadersArray.length);
            newArray[loadersArray.length] = loader;
            map2.put(hash, newArray);
        }
    }

    static String transformName(String name) {
        int nameEnd = !name.isEmpty() && name.charAt(name.length() - 1) == '/' ? name.length() - 1 : name.length();
        if ((name = name.substring(name.lastIndexOf(47, nameEnd - 1) + 1, nameEnd)).endsWith(".class")) {
            String name1 = name;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index2 = name1.lastIndexOf(46);
                if (index2 >= 0) {
                    name1 = name1.substring(0, index2);
                }
            }
            name = name1;
        }
        return name;
    }

    static class NameFilter
    extends BloomFilterBase {
        protected NameFilter(int _maxElementCount, double probability) {
            super(_maxElementCount, probability);
        }

        protected NameFilter(DataInput input) throws IOException {
            super(input);
        }

        private void addNameFingerprint(long nameFingerprint) {
            int hash = (int)(nameFingerprint >> 32);
            int hash2 = (int)nameFingerprint;
            this.addIt(hash, hash2);
        }

        boolean maybeContains(String name) {
            int hash = name.hashCode();
            int hash2 = StringHash.murmur(name, 31);
            return this.maybeContains(hash, hash2);
        }

        @Override
        protected void save(DataOutput output) throws IOException {
            super.save(output);
        }

        private static long toNameFingerprint(String name) {
            int hash = name.hashCode();
            int hash2 = StringHash.murmur(name, 31);
            return (long)hash << 32 | (long)hash2 & 0xFFFFFFFFL;
        }
    }

    static abstract class LoaderIterator<ResultType, ParameterType, ParameterType2> {
        LoaderIterator() {
        }

        @Nullable
        abstract ResultType process(Loader var1, ParameterType var2, ParameterType2 var3, String var4);
    }

    static class LoaderDataBuilder {
        private final TLongHashSet myUsedNameFingerprints = new TLongHashSet();
        private final TIntHashSet myResourcePackageHashes = new TIntHashSet();
        private final TIntHashSet myClassPackageHashes = new TIntHashSet();

        LoaderDataBuilder() {
        }

        void addPossiblyDuplicateNameEntry(String name) {
            name = ClasspathCache.transformName(name);
            this.myUsedNameFingerprints.add(NameFilter.toNameFingerprint(name));
        }

        void addResourcePackageFromName(String path2) {
            this.myResourcePackageHashes.add(ClasspathCache.getPackageNameHash(path2));
        }

        void addClassPackageFromName(String path2) {
            this.myClassPackageHashes.add(ClasspathCache.getPackageNameHash(path2));
        }

        LoaderData build() {
            int uniques = this.myUsedNameFingerprints.size();
            if (uniques > 20000) {
                uniques += (int)((double)uniques * 0.03);
            }
            final NameFilter nameFilter2 = new NameFilter(uniques, 0.005);
            this.myUsedNameFingerprints.forEach(new TLongProcedure(){

                public boolean execute(long value2) {
                    nameFilter2.addNameFingerprint(value2);
                    return true;
                }
            });
            return new LoaderData(this.myResourcePackageHashes.toArray(), this.myClassPackageHashes.toArray(), nameFilter2);
        }
    }

    static class LoaderData {
        private final int[] myResourcePackageHashes;
        private final int[] myClassPackageHashes;
        private final NameFilter myNameFilter;

        @Deprecated
        LoaderData() {
            this(new int[0], new int[0], null);
        }

        LoaderData(int[] resourcePackageHashes, int[] classPackageHashes, NameFilter nameFilter2) {
            this.myResourcePackageHashes = resourcePackageHashes;
            this.myClassPackageHashes = classPackageHashes;
            this.myNameFilter = nameFilter2;
        }

        LoaderData(DataInput dataInput) throws IOException {
            this(LoaderData.readIntList(dataInput), LoaderData.readIntList(dataInput), new NameFilter(dataInput));
        }

        private static int[] readIntList(DataInput reader) throws IOException {
            int numberOfElements = DataInputOutputUtilRt.readINT(reader);
            int[] ints = new int[numberOfElements];
            for (int i = 0; i < numberOfElements; ++i) {
                ints[i] = DataInputOutputUtilRt.readINT(reader);
            }
            return ints;
        }

        void save(DataOutput dataOutput) throws IOException {
            LoaderData.writeIntArray(dataOutput, this.myResourcePackageHashes);
            LoaderData.writeIntArray(dataOutput, this.myClassPackageHashes);
            this.myNameFilter.save(dataOutput);
        }

        private static void writeIntArray(DataOutput writer, int[] hashes) throws IOException {
            DataInputOutputUtilRt.writeINT(writer, hashes.length);
            for (int hash : hashes) {
                DataInputOutputUtilRt.writeINT(writer, hash);
            }
        }

        NameFilter getNameFilter() {
            return this.myNameFilter;
        }
    }
}

