/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassLevelDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.InheritanceImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSuperMethodImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassInitializerStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.ClassInnerStuffCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiExtensibleClass;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stub.JavaStubImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiClassImpl
extends JavaStubPsiElement<PsiClassStub<?>>
implements Queryable,
PsiExtensibleClass {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiClassImpl");
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);
    private volatile String myCachedName;

    public PsiClassImpl(PsiClassStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.CLASS);
    }

    protected PsiClassImpl(PsiClassStub stub, IStubElementType type2) {
        super(stub, type2);
        this.addTrace(null);
    }

    public PsiClassImpl(ASTNode node) {
        super(node);
        this.addTrace(null);
    }

    private void addTrace(@Nullable PsiClassStub stub) {
        if (ourTraceStubAstBinding) {
            String creationTrace = "Creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            if (stub != null) {
                String stubTrace;
                creationTrace = creationTrace + "\nfrom stub " + stub + "@" + System.identityHashCode(stub) + "\n";
                if (stub instanceof UserDataHolder && (stubTrace = (String)((UserDataHolder)((Object)stub)).getUserData(CREATION_TRACE)) != null) {
                    creationTrace = creationTrace + stubTrace;
                }
            }
            this.putUserData(CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public void subtreeChanged() {
        this.dropCaches();
        super.subtreeChanged();
    }

    private void dropCaches() {
        this.myInnersCache.dropCaches();
        this.myCachedName = null;
    }

    @Override
    protected Object clone() {
        PsiClassImpl clone = (PsiClassImpl)super.clone();
        clone.dropCaches();
        return clone;
    }

    @Override
    public PsiElement getOriginalElement() {
        return (PsiElement)CachedValuesManager.getCachedValue(this, () -> {
            JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(this.getProject());
            PsiClassImpl result2 = helper != null ? helper.getOriginalClass(this) : this;
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiClassImpl.$$$reportNull$$$0(0);
        }
        return compositeElement;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @Override
    public PsiElement getScope() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        CompositeElement treeElement = this.getNode();
        for (ASTNode parent2 = treeElement.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
            if (!(parent2.getElementType() instanceof IStubElementType)) continue;
            return parent2.getPsi();
        }
        return this.getContainingFile();
    }

    @Override
    public String getName() {
        PsiIdentifier identifier;
        String name = this.myCachedName;
        if (name != null) {
            return name;
        }
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        name = stub == null ? ((identifier = this.getNameIdentifier()) == null ? null : identifier.getText()) : stub.getName();
        this.myCachedName = name;
        return name;
    }

    @Override
    public String getQualifiedName() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiJavaFile) {
            return StringUtil.getQualifiedName(((PsiJavaFile)parent2).getPackageName(), StringUtil.notNullize(this.getName()));
        }
        if (parent2 instanceof PsiClass) {
            String parentQName = ((PsiClass)parent2).getQualifiedName();
            if (parentQName == null) {
                return null;
            }
            return StringUtil.getQualifiedName(parentQName, StringUtil.notNullize(this.getName()));
        }
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        PsiModifierList modlist;
        if (name == null) {
            PsiClassImpl.$$$reportNull$$$0(1);
        }
        return (modlist = this.getModifierList()) != null && modlist.hasModifierProperty(name);
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.EXTENDS_LIST);
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.IMPLEMENTS_LIST);
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(2);
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(3);
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @Override
    @NotNull
    public PsiClass[] getInterfaces() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getInterfaces(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            PsiClassImpl.$$$reportNull$$$0(6);
        }
        return psiClassTypeArray;
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            StubElement parent2 = stub.getParentStub();
            return parent2 instanceof PsiClassStub ? (PsiClass)((PsiClassStub)parent2).getPsi() : null;
        }
        PsiElement parent3 = this.getParent();
        if (parent3 instanceof PsiClassLevelDeclarationStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
        }
        return parent3 instanceof PsiClass ? (PsiClass)parent3 : null;
    }

    @Override
    public PsiElement getContext() {
        StubElement contextStub = this.getContextStub();
        if (contextStub != null) {
            return contextStub.getPsi();
        }
        return super.getContext();
    }

    @Nullable
    private StubElement getContextStub() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            return null;
        }
        StubElement parent2 = stub.getParentStub();
        if ((parent2 instanceof PsiClassInitializerStub || parent2 instanceof PsiMethodStub) && parent2.getChildrenByType(JavaStubElementTypes.CLASS, PsiElement.ARRAY_FACTORY).length <= 1) {
            parent2 = parent2.getParentStub();
        }
        return parent2 instanceof PsiClassStub ? parent2 : null;
    }

    @Override
    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            PsiClassImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            PsiClassImpl.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiElement> list2 = Arrays.asList(this.getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list2 == null) {
            PsiClassImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiElement> list2 = Arrays.asList(this.getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list2 == null) {
            PsiClassImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiElement> list2 = Arrays.asList(this.getStubOrPsiChildren(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
        if (list2 == null) {
            PsiClassImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiClassInitializer[] getInitializers() {
        PsiClassInitializer[] psiClassInitializerArray = (PsiClassInitializer[])this.getStubOrPsiChildren(JavaStubElementTypes.CLASS_INITIALIZER, PsiClassInitializer.ARRAY_FACTORY);
        if (psiClassInitializerArray == null) {
            PsiClassImpl.$$$reportNull$$$0(15);
        }
        return psiClassInitializerArray;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            PsiClassImpl.$$$reportNull$$$0(16);
        }
        return psiTypeParameterArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            PsiClassImpl.$$$reportNull$$$0(17);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(18);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            PsiClassImpl.$$$reportNull$$$0(19);
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name, checkBases);
    }

    @Override
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(20);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            PsiClassImpl.$$$reportNull$$$0(21);
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list2 = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list2 == null) {
            PsiClassImpl.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list2 = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list2 == null) {
            PsiClassImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    @Override
    public PsiDocComment getDocComment() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    @Override
    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(18);
    }

    @Override
    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(19);
    }

    @Override
    public boolean isInterface() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.INTERFACE_KEYWORD;
    }

    @Override
    public boolean isAnnotationType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnnotationType();
        }
        return this.getNode().findChildByRole(247) != null;
    }

    @Override
    public boolean isEnum() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isEnum();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.ENUM_KEYWORD;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiClassImpl.$$$reportNull$$$0(24);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitClass(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiClassImpl.$$$reportNull$$$0(25);
        }
        if (state == null) {
            PsiClassImpl.$$$reportNull$$$0(26);
        }
        if (place == null) {
            PsiClassImpl.$$$reportNull$$$0(27);
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor2, state, this.myInnersCache)) {
            return false;
        }
        LanguageLevel level = PsiUtil.getLanguageLevel(place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor2, state, null, lastParent, place, level, false);
    }

    @Override
    public PsiElement setName(@NotNull String newName2) throws IncorrectOperationException {
        if (newName2 == null) {
            PsiClassImpl.$$$reportNull$$$0(28);
        }
        String oldName = this.getName();
        boolean isRenameFile = this.isRenameFileOnRenaming();
        PsiImplUtil.setName(this.getNameIdentifier(), newName2);
        if (isRenameFile) {
            PsiFile file2;
            String fileName = (file2 = (PsiFile)this.getParent()).getName();
            int dotIndex = fileName.lastIndexOf(46);
            file2.setName(dotIndex >= 0 ? newName2 + "." + fileName.substring(dotIndex + 1) : newName2);
        }
        for (PsiMethod method : this.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
            method.setName(newName2);
        }
        return this;
    }

    private boolean isRenameFileOnRenaming() {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiFile) {
            PsiFile file2 = (PsiFile)parent2;
            String fileName = file2.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String name = dotIndex >= 0 ? fileName.substring(0, dotIndex) : fileName;
            String oldName = this.getName();
            return name.equals(oldName);
        }
        return false;
    }

    @Nullable
    public PsiElement calcBasesResolveContext(String baseClassName, PsiElement defaultResolveContext) {
        return PsiClassImpl.calcBasesResolveContext(this, baseClassName, true, defaultResolveContext);
    }

    private static boolean isAnonymousOrLocal(PsiClass aClass2) {
        if (aClass2 instanceof PsiAnonymousClass) {
            return true;
        }
        PsiClassStub stub = (PsiClassStub)((PsiClassImpl)aClass2).getGreenStub();
        if (stub != null) {
            StubElement parentStub = stub.getParentStub();
            return !(parentStub instanceof PsiClassStub) && !(parentStub instanceof PsiFileStub);
        }
        for (PsiElement parent2 = aClass2.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2 instanceof PsiMethod || parent2 instanceof PsiField || parent2 instanceof PsiClassInitializer) {
                return true;
            }
            if (!(parent2 instanceof PsiClass) && !(parent2 instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    @Nullable
    private static PsiElement calcBasesResolveContext(@NotNull PsiElement scope, String baseClassName, boolean isInitialClass, PsiElement defaultResolveContext) {
        StubElement parentStub;
        Object psi;
        StubElement stub;
        if (scope == null) {
            PsiClassImpl.$$$reportNull$$$0(29);
        }
        StubElement stubElement = stub = scope instanceof StubBasedPsiElementBase ? (StubElement)((StubBasedPsiElementBase)scope).getStub() : null;
        if (stub == null || stub instanceof PsiClassStub && ((PsiClassStub)stub).isAnonymousInQualifiedNew()) {
            return scope.getParent();
        }
        if (scope instanceof PsiClass) {
            if (!PsiClassImpl.isAnonymousOrLocal((PsiClass)scope)) {
                return isInitialClass ? defaultResolveContext : scope;
            }
            if (!isInitialClass && ((PsiClass)scope).findInnerClassByName(baseClassName, true) != null) {
                return scope;
            }
        }
        if (!((psi = (parentStub = stub.getParentStub()).getPsi()) instanceof StubBasedPsiElementBase)) {
            return null;
        }
        if (PsiClassImpl.hasChildClassStub(parentStub, baseClassName, scope)) {
            return scope.getParent();
        }
        if (psi instanceof PsiMember) {
            return psi;
        }
        if (psi instanceof PsiFunctionalExpression) {
            return PsiClassImpl.calcBasesResolveContext(psi, baseClassName, false, defaultResolveContext);
        }
        LOG.error(parentStub);
        return psi;
    }

    private static boolean hasChildClassStub(StubElement parentStub, String className2, PsiElement place) {
        PsiClass[] classesInScope;
        for (PsiClass scopeClass : classesInScope = (PsiClass[])parentStub.getChildrenByType(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY)) {
            if (scopeClass == place || !className2.equals(scopeClass.getName())) continue;
            return true;
        }
        if (place instanceof PsiClass) {
            if (classesInScope.length == 0) {
                LOG.error("Parent stub: " + parentStub.getStubType() + "; children: " + parentStub.getChildrenStubs() + "; \ntext:" + parentStub.getPsi().getText());
            }
            LOG.assertTrue(Arrays.asList(classesInScope).contains(place));
        }
        return false;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            PsiClassImpl.$$$reportNull$$$0(30);
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Override
    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            PsiClassImpl.$$$reportNull$$$0(31);
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info2) {
        if (info2 == null) {
            PsiClassImpl.$$$reportNull$$$0(32);
        }
        PsiClassImpl.putInfo(this, info2);
    }

    public static void putInfo(@NotNull PsiClass psiClass, @NotNull Map<String, String> info2) {
        if (psiClass == null) {
            PsiClassImpl.$$$reportNull$$$0(33);
        }
        if (info2 == null) {
            PsiClassImpl.$$$reportNull$$$0(34);
        }
        info2.put("className", psiClass.getName());
        info2.put("qualifiedClassName", psiClass.getQualifiedName());
        PsiFile file2 = psiClass.getContainingFile();
        if (file2 instanceof Queryable) {
            ((Queryable)((Object)file2)).putInfo(info2);
        }
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return this.myInnersCache.getValuesMethod();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiClassImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiClassImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodsAndTheirSubstitutors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calcBasesResolveContext";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

