/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.picocontainer.MutablePicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = Boolean.FALSE;
    private final MutablePicoContainer myPicoContainer;
    private final Map<String, ExtensionPointImpl> myExtensionPoints = ContainerUtil.newConcurrentMap();
    private final Map<String, Throwable> myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners = MultiMap.createSmart();
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(@Nullable String areaClass, @Nullable AreaInstance areaInstance, PicoContainer parentPicoContainer) {
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.initialize();
    }

    public final void notifyAreaReplaced(@NotNull ExtensionsAreaImpl newArea) {
        if (newArea == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        THashSet processedEPs = new THashSet();
        for (ExtensionPointImpl extensionPointImpl : this.myExtensionPoints.values()) {
            extensionPointImpl.notifyAreaReplaced(this);
            processedEPs.add(extensionPointImpl.getName());
        }
        if (!this.myAvailabilityListeners.isEmpty()) {
            for (Map.Entry entry : this.myAvailabilityListeners.entrySet()) {
                String key = (String)entry.getKey();
                if (processedEPs.contains(key)) continue;
                boolean wasAdded = false;
                for (ExtensionPointAvailabilityListener listener : (Collection)entry.getValue()) {
                    if (newArea.hasAvailabilityListener(key, listener)) continue;
                    newArea.addAvailabilityListener(key, listener, null);
                    wasAdded = true;
                }
                if (!wasAdded) continue;
                processedEPs.add(key);
            }
        }
        for (ExtensionPointImpl extensionPointImpl : newArea.myExtensionPoints.values()) {
            if (processedEPs.contains(extensionPointImpl.getName())) continue;
            extensionPointImpl.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(1);
        }
        return mutablePicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        ExtensionPointImpl point;
        String pointName;
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        if (extensionPointElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(3);
        }
        if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin");
            }
            assert (pluginDescriptor.getPluginId() != null);
            pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin");
        }
        if (interfaceClassName == null) {
            point = new BeanExtensionPoint(pointName, beanClassName, this.myPicoContainer, pluginDescriptor);
        } else {
            boolean registerInPicoContainer;
            String registerInPicoContainerValue = extensionPointElement.getAttributeValue("registerInPicoContainer");
            if (registerInPicoContainerValue == null) {
                String pluginId = pluginDescriptor.getPluginId().getIdString();
                registerInPicoContainer = SystemProperties.getBooleanProperty("idea.register.ep.in.pico.container", !pluginDescriptor.isBundled()) || pluginId.equals("Lombook Plugin");
            } else {
                registerInPicoContainer = Boolean.parseBoolean(registerInPicoContainerValue);
            }
            point = registerInPicoContainer ? new InterfaceExtensionPoint.PicoContainerAwareInterfaceExtensionPoint(pointName, interfaceClassName, this.myPicoContainer, pluginDescriptor) : new InterfaceExtensionPoint(pointName, interfaceClassName, this.myPicoContainer, pluginDescriptor);
        }
        this.registerExtensionPoint(point);
    }

    public void extensionsRegistered(@NotNull ExtensionPointImpl[] points) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        for (ExtensionPointImpl point : points) {
            point.clearCache();
        }
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(10);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string2 = epName;
        if (string2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private void initialize() {
        InterfaceExtensionPoint<EPAvailabilityListenerExtension> point = new InterfaceExtensionPoint<EPAvailabilityListenerExtension>("org.jetbrains.kotlin.com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class, this.myPicoContainer);
        this.registerExtensionPoint(point);
        point.addExtensionPointListener(new ExtensionPointListener<EPAvailabilityListenerExtension>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extensionRemoved(@NotNull EPAvailabilityListenerExtension extension2, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                MultiMap multiMap = ExtensionsAreaImpl.this.myAvailabilityListeners;
                synchronized (multiMap) {
                    Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(extension2.getExtensionPointName());
                    Iterator iterator2 = listeners.iterator();
                    while (iterator2.hasNext()) {
                        ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator2.next();
                        if (!listener.getClass().getName().equals(extension2.getListenerClass())) continue;
                        iterator2.remove();
                        return;
                    }
                }
                LOG.warn("Failed to find EP availability listener: " + extension2.getListenerClass());
            }

            @Override
            public void extensionAdded(@NotNull EPAvailabilityListenerExtension extension2, @Nullable PluginDescriptor pluginDescriptor) {
                ExtensionPointAvailabilityListener listener;
                if (extension2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                String epName = extension2.getExtensionPointName();
                try {
                    listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(extension2.loadListenerClass());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "extension";
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, null);
    }

    @NotNull
    private Object instantiate(@NotNull Class clazz) {
        if (clazz == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(12);
        }
        CachingConstructorInjectionComponentAdapter adapter = new CachingConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        Object object = adapter.getComponentInstance(this.getPicoContainer());
        if (object == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(13);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAvailabilityListener(final @NotNull String extensionPointName, final @NotNull ExtensionPointAvailabilityListener listener, @Nullable Disposable parentDisposable) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            this.myAvailabilityListeners.putValue(extensionPointName, listener);
        }
        ExtensionPointImpl ep = this.myExtensionPoints.get(extensionPointName);
        if (ep != null) {
            listener.extensionPointRegistered(ep);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    ExtensionsAreaImpl.this.removeAvailabilityListener(extensionPointName, listener);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            this.myAvailabilityListeners.remove(extensionPointName, listener);
        }
    }

    private boolean hasAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        if (listener == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPointName);
        return ContainerUtil.containsIdentity(listeners, listener);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        UndefinedPluginDescriptor pluginDescriptor = new UndefinedPluginDescriptor();
        ExtensionPointImpl point = kind == ExtensionPoint.Kind.INTERFACE ? new InterfaceExtensionPoint.PicoContainerAwareInterfaceExtensionPoint(extensionPointName, extensionPointBeanClass, this.myPicoContainer, pluginDescriptor) : new BeanExtensionPoint(extensionPointName, extensionPointBeanClass, this.myPicoContainer, pluginDescriptor);
        this.registerExtensionPoint(point);
    }

    @Nullable
    private static PluginId extractPluginId(@NotNull PluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        return descriptor2 instanceof UndefinedPluginDescriptor ? null : descriptor2.getPluginId();
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        String message2 = "Duplicate registration for EP: " + pointName + ": original plugin " + ExtensionsAreaImpl.extractPluginId(((ExtensionPointImpl)this.getExtensionPoint(pointName)).getDescriptor()) + ", new plugin " + ExtensionsAreaImpl.extractPluginId(pluginDescriptor);
        if (DEBUG_REGISTRATION) {
            LOG.error(message2, this.myEPTraces.get(pointName));
        }
        throw new PicoPluginExtensionInitializationException(message2, null, ExtensionsAreaImpl.extractPluginId(pluginDescriptor));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getDescriptor());
        this.myExtensionPoints.put(name, point);
        this.notifyPointRegistered(point);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPointRegistered(@NotNull ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners;
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        MultiMap<String, ExtensionPointAvailabilityListener> multiMap = this.myAvailabilityListeners;
        synchronized (multiMap) {
            listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        }
        for (ExtensionPointAvailabilityListener listener : listeners) {
            listener.extensionPointRegistered(extensionPoint);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if ((extensionPoint = this.myExtensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        return extensionPointImpl;
    }

    @Override
    @Nullable
    public <T> ExtensionPoint<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        return this.myExtensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(39);
        }
        return extensionPoint;
    }

    @NotNull
    public ExtensionPointImpl[] getExtensionPoints() {
        ExtensionPointImpl[] extensionPointImplArray = this.myExtensionPoints.values().toArray(new ExtensionPointImpl[0]);
        if (extensionPointImplArray == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(40);
        }
        return extensionPointImplArray;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return (this.myAreaClass == null ? "Root" : this.myAreaClass) + " Area";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 36: 
            case 39: 
            case 40: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 36: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArea";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 6: 
            case 23: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 27: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiate";
                break;
            }
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 36: 
            case 39: 
            case 40: {
                break;
            }
            case 2: 
            case 3: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extensionsRegistered";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAvailabilityListener";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeAvailabilityListener";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasAvailabilityListener";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractPluginId";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notifyPointRegistered";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "notifyEPRemoved";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 36: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

