/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.DefaultProjectModuleFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;

public class DefaultIvyPublicationIdentity
implements IvyPublicationIdentity {
    private Module delegate;
    private String organisation;
    private String module;
    private String revision;

    public DefaultIvyPublicationIdentity(Module delegate) {
        this.delegate = this.safeProjectCoordinatesProvider(delegate);
    }

    public DefaultIvyPublicationIdentity(String organisation, String module, String revision) {
        this.organisation = organisation;
        this.module = module;
        this.revision = revision;
    }

    @Override
    public String getOrganisation() {
        return this.organisation != null ? this.organisation : (this.delegate != null ? this.delegate.getGroup() : null);
    }

    @Override
    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    @Override
    public String getModule() {
        return this.module != null ? this.module : (this.delegate != null ? this.delegate.getName() : null);
    }

    @Override
    public void setModule(String module) {
        this.module = module;
    }

    @Override
    public String getRevision() {
        return this.revision != null ? this.revision : (this.delegate != null ? this.delegate.getVersion() : null);
    }

    @Override
    public void setRevision(String revision) {
        this.revision = revision;
    }

    private Module safeProjectCoordinatesProvider(Module module) {
        if (module instanceof ProjectBackedModule) {
            return new LazyProjectModuleProvider((ProjectBackedModule)module);
        }
        return module;
    }

    private static final class LazyProjectModuleProvider
    implements Module {
        private final ProjectBackedModule projectBackedModule;
        private final AtomicBoolean warned = new AtomicBoolean();

        private LazyProjectModuleProvider(ProjectBackedModule module) {
            this.projectBackedModule = module;
        }

        @Nullable
        public String getProjectPath() {
            return this.projectBackedModule.getProjectPath();
        }

        public String getGroup() {
            this.maybeWarnAboutDuplicates();
            return this.projectBackedModule.getGroup();
        }

        public String getName() {
            this.maybeWarnAboutDuplicates();
            return this.projectBackedModule.getName();
        }

        public String getVersion() {
            return this.projectBackedModule.getVersion();
        }

        public String getStatus() {
            return this.projectBackedModule.getStatus();
        }

        private void maybeWarnAboutDuplicates() {
            if (!this.warned.getAndSet(true)) {
                Project project = this.projectBackedModule.getProject();
                List projectsWithSameId = this.projectBackedModule.getProjectsWithSameCoordinates();
                if (!projectsWithSameId.isEmpty() && DefaultProjectModuleFactory.isDuplicateDetectionEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Project ").append(project.getPath()).append(" has the same (organisation, module name) as ").append(projectsWithSameId.stream().map(Project::getPath).collect(Collectors.joining(" and "))).append(". You should set both the organisation and module name of the publication").append(" or opt out by adding the org.gradle.dependency.duplicate.project.detection system property to 'false'.");
                    throw new InvalidUserCodeException(sb.toString());
                }
            }
        }
    }
}

