/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

class ResolvedVariantResultSerializer
implements Serializer<ResolvedVariantResult> {
    private final Map<ResolvedVariantResult, Integer> written = Maps.newHashMap();
    private final List<ResolvedVariantResult> read = Lists.newArrayList();
    private final AttributeContainerSerializer attributeContainerSerializer;

    ResolvedVariantResultSerializer(AttributeContainerSerializer attributeContainerSerializer) {
        this.attributeContainerSerializer = attributeContainerSerializer;
    }

    public ResolvedVariantResult read(Decoder decoder) throws IOException {
        int index = decoder.readSmallInt();
        if (index == -1) {
            return null;
        }
        if (index == this.read.size()) {
            String variantName = decoder.readString();
            ImmutableAttributes attributes = this.attributeContainerSerializer.read(decoder);
            List<Capability> capabilities = this.readCapabilities(decoder);
            DefaultResolvedVariantResult result = new DefaultResolvedVariantResult(Describables.of((Object)variantName), (AttributeContainer)attributes, capabilities);
            this.read.add(result);
            return result;
        }
        return this.read.get(index);
    }

    private List<Capability> readCapabilities(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder capabilities = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            String group = decoder.readString();
            String name = decoder.readString();
            String version = decoder.readNullableString();
            capabilities.add((Object)new ImmutableCapability(group, name, version));
        }
        return capabilities.build();
    }

    public void write(Encoder encoder, ResolvedVariantResult variant) throws IOException {
        if (variant == null) {
            encoder.writeSmallInt(-1);
            return;
        }
        Integer index = this.written.get(variant);
        if (index == null) {
            index = this.written.size();
            this.written.put(variant, index);
            encoder.writeSmallInt(index.intValue());
            encoder.writeString((CharSequence)variant.getDisplayName());
            this.attributeContainerSerializer.write(encoder, variant.getAttributes());
            this.writeCapabilities(encoder, variant.getCapabilities());
        } else {
            encoder.writeSmallInt(index.intValue());
        }
    }

    private void writeCapabilities(Encoder encoder, List<Capability> capabilities) throws IOException {
        encoder.writeSmallInt(capabilities.size());
        for (Capability capability : capabilities) {
            encoder.writeString((CharSequence)capability.getGroup());
            encoder.writeString((CharSequence)capability.getName());
            encoder.writeNullableString((CharSequence)capability.getVersion());
        }
    }

    void reset() {
        this.written.clear();
        this.read.clear();
    }
}

