/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.ComponentVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.ImmutableArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.ImmutableComponentVerificationMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

public class DependencyVerifierBuilder {
    private final Map<ModuleComponentIdentifier, ComponentVerificationsBuilder> byComponent = Maps.newLinkedHashMap();

    public void addChecksum(ModuleComponentArtifactIdentifier artifact, ChecksumKind kind, String value, @Nullable String origin) {
        ModuleComponentIdentifier componentIdentifier = artifact.getComponentIdentifier();
        this.byComponent.computeIfAbsent(componentIdentifier, id -> new ComponentVerificationsBuilder((ModuleComponentIdentifier)id)).addChecksum(artifact, kind, value, origin);
    }

    public DependencyVerifier build() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.byComponent.size());
        for (Map.Entry<ModuleComponentIdentifier, ComponentVerificationsBuilder> entry : this.byComponent.entrySet()) {
            builder.put((Object)((ComponentIdentifier)entry.getKey()), (Object)entry.getValue().build());
        }
        return new DependencyVerifier((Map<ComponentIdentifier, ComponentVerificationMetadata>)builder.build());
    }

    private static class ChecksumBuilder {
        private final ChecksumKind kind;
        private String value;
        private String origin;
        private Set<String> alternatives;

        private ChecksumBuilder(ChecksumKind kind) {
            this.kind = kind;
        }

        void withOrigin(String origin) {
            if (this.origin == null) {
                this.origin = origin;
            }
        }

        void addChecksum(String checksum) {
            if (this.value == null) {
                this.value = checksum;
            } else if (!this.value.equals(checksum)) {
                if (this.alternatives == null) {
                    this.alternatives = Sets.newLinkedHashSet();
                }
                this.alternatives.add(checksum);
            }
        }

        Checksum build() {
            return new Checksum(this.kind, this.value, this.alternatives, this.origin);
        }
    }

    private static class ChecksumsBuilder {
        private final Map<ChecksumKind, ChecksumBuilder> builder = Maps.newEnumMap(ChecksumKind.class);

        private ChecksumsBuilder() {
        }

        void addChecksum(ChecksumKind kind, String value, @Nullable String origin) {
            ChecksumBuilder builder = this.builder.computeIfAbsent(kind, x$0 -> new ChecksumBuilder((ChecksumKind)((Object)x$0)));
            builder.addChecksum(value);
            if (origin != null) {
                builder.withOrigin(origin);
            }
        }

        List<Checksum> build() {
            return this.builder.values().stream().map(ChecksumBuilder::build).collect(Collectors.toList());
        }
    }

    private static class ComponentVerificationsBuilder {
        private final ModuleComponentIdentifier component;
        private final Map<String, ChecksumsBuilder> checksums = Maps.newLinkedHashMap();

        private ComponentVerificationsBuilder(ModuleComponentIdentifier component) {
            this.component = component;
        }

        void addChecksum(ModuleComponentArtifactIdentifier artifact, ChecksumKind kind, String value, @Nullable String origin) {
            this.checksums.computeIfAbsent(artifact.getFileName(), id -> new ChecksumsBuilder()).addChecksum(kind, value, origin);
        }

        private static ArtifactVerificationMetadata toArtifactVerification(Map.Entry<String, ChecksumsBuilder> entry) {
            return new ImmutableArtifactVerificationMetadata(entry.getKey(), entry.getValue().build());
        }

        ComponentVerificationMetadata build() {
            return new ImmutableComponentVerificationMetadata(this.component, this.checksums.entrySet().stream().map(ComponentVerificationsBuilder::toArtifactVerification).collect(Collectors.toList()));
        }
    }
}

