/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.language.twirl.internal.DefaultTwirlTemplateFormat;
import org.gradle.play.internal.twirl.VersionedPlayTwirlAdapter;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaCodecMapper;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;

class TwirlCompilerAdapterV10X
extends VersionedTwirlCompilerAdapter {
    protected final String scalaVersion;
    protected final String twirlVersion;
    protected final VersionedPlayTwirlAdapter playTwirlAdapter;

    public TwirlCompilerAdapterV10X(String twirlVersion, String scalaVersion, VersionedPlayTwirlAdapter playTwirlAdapter) {
        this.scalaVersion = scalaVersion;
        this.twirlVersion = twirlVersion;
        this.playTwirlAdapter = playTwirlAdapter;
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.twirl.compiler.TwirlCompiler", "compile", File.class, File.class, File.class, String.class, String.class, cl.loadClass(ScalaCodecMapper.getClassName()), Boolean.TYPE, Boolean.TYPE);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File sourceDirectory, File destinationDirectory, TwirlImports defaultPlayImports, TwirlTemplateFormat templateFormat, List<String> additionalImports) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        List<String> defaultImports = this.playTwirlAdapter.getDefaultImports(defaultPlayImports);
        return new Object[]{file, sourceDirectory, destinationDirectory, templateFormat.getFormatType(), this.getImportsFor(templateFormat, defaultImports, additionalImports), ScalaCodecMapper.create(cl, "UTF-8"), this.isInclusiveDots(), this.isUseOldParser()};
    }

    protected boolean isInclusiveDots() {
        return false;
    }

    private boolean isUseOldParser() {
        return false;
    }

    @Override
    public List<String> getDependencyNotation() {
        return Collections.singletonList("com.typesafe.play:twirl-compiler_" + this.scalaVersion + ":" + this.twirlVersion);
    }

    @Override
    public Collection<TwirlTemplateFormat> getDefaultTemplateFormats() {
        return Arrays.asList(new DefaultTwirlTemplateFormat("html", "play.twirl.api.HtmlFormat", Collections.singleton("views.html._")), new DefaultTwirlTemplateFormat("txt", "play.twirl.api.TxtFormat", Collections.singleton("views.txt._")), new DefaultTwirlTemplateFormat("xml", "play.twirl.api.XmlFormat", Collections.singleton("views.xml._")), new DefaultTwirlTemplateFormat("js", "play.twirl.api.JavaScriptFormat", Collections.singleton("views.js._")));
    }
}

