/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public abstract class PsiDiamondType
extends PsiType {
    public static final RecursionGuard ourDiamondGuard = RecursionManager.createGuard("diamondInference");

    public PsiDiamondType() {
        super(TypeAnnotationProvider.EMPTY);
    }

    public abstract DiamondInferenceResult resolveInferredTypes();

    public static boolean hasDiamond(PsiNewExpression expression2) {
        return PsiDiamondType.getDiamondType(expression2) != null;
    }

    public static PsiDiamondType getDiamondType(PsiNewExpression expression2) {
        PsiTypeElement[] parameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.isLanguageLevel7OrHigher(expression2) && (classReference = expression2.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (parameterElements = parameterList.getTypeParameterElements()).length == 1) {
            PsiType type2 = parameterElements[0].getType();
            return type2 instanceof PsiDiamondType ? (PsiDiamondType)type2 : null;
        }
        return null;
    }

    public static JavaResolveResult getDiamondsAwareResolveResult(PsiCall expression2) {
        PsiDiamondType diamondType;
        if (expression2 instanceof PsiNewExpression && (diamondType = PsiDiamondType.getDiamondType((PsiNewExpression)expression2)) != null) {
            JavaResolveResult factory2 = diamondType.getStaticFactory();
            return factory2 != null ? factory2 : JavaResolveResult.EMPTY;
        }
        return expression2.resolveMethodGenerics();
    }

    @Nullable
    public abstract JavaResolveResult getStaticFactory();

    public static class DiamondInferenceResult {
        public static final DiamondInferenceResult EXPLICIT_CONSTRUCTOR_TYPE_ARGS = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use diamonds with explicit type parameters for constructor";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$1", "getTypes"));
            }
        };
        public static final DiamondInferenceResult NULL_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$2", "getTypes"));
            }
        };
        public static final DiamondInferenceResult RAW_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$3", "getTypes"));
            }
        };
        public static final DiamondInferenceResult UNRESOLVED_CONSTRUCTOR = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot infer arguments (unable to resolve constructor)";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$4", "getTypes"));
            }
        };
        public static final DiamondInferenceResult ANONYMOUS_INNER_RESULT = new DiamondInferenceResult(){

            @Override
            @NotNull
            public PsiType[] getTypes() {
                if (PsiType.EMPTY_ARRAY == null) {
                    5.$$$reportNull$$$0(0);
                }
                return PsiType.EMPTY_ARRAY;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot use ''<>'' with anonymous inner classes";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult$5", "getTypes"));
            }
        };
        private final List<PsiType> myInferredTypes = new ArrayList<PsiType>();
        private String myErrorMessage;
        private String myNewExpressionPresentableText;

        public DiamondInferenceResult() {
        }

        public DiamondInferenceResult(String expressionPresentableText) {
            this.myNewExpressionPresentableText = expressionPresentableText;
        }

        @NotNull
        public PsiType[] getTypes() {
            PsiType[] psiTypeArray = this.myErrorMessage == null ? this.myInferredTypes.toArray(PsiType.createArray(this.myInferredTypes.size())) : PsiType.EMPTY_ARRAY;
            if (psiTypeArray == null) {
                DiamondInferenceResult.$$$reportNull$$$0(0);
            }
            return psiTypeArray;
        }

        public List<PsiType> getInferredTypes() {
            return this.myInferredTypes;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public boolean failedToInfer() {
            return this.myErrorMessage != null;
        }

        protected void addInferredType(PsiType psiType2) {
            if (this.myErrorMessage != null) {
                return;
            }
            if (psiType2 == null) {
                this.myErrorMessage = "Cannot infer type arguments for " + this.myNewExpressionPresentableText;
            } else {
                this.myInferredTypes.add(psiType2);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiamondInferenceResult that = (DiamondInferenceResult)o;
            if (this.myErrorMessage != null ? !this.myErrorMessage.equals(that.myErrorMessage) : that.myErrorMessage != null) {
                return false;
            }
            return this.myInferredTypes.equals(that.myInferredTypes);
        }

        public int hashCode() {
            int result2 = this.myInferredTypes.hashCode();
            result2 = 31 * result2 + (this.myErrorMessage != null ? this.myErrorMessage.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiDiamondType$DiamondInferenceResult", "getTypes"));
        }
    }
}

