/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionInterfaceFactoryKt;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.serialization.js.PackagesWithHeaderMetadata;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J<\u0010\u0015\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\rJ\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "friendModuleDescriptors", "thisIsBuiltInsModule", "", "customBuiltInsModule", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "additionalPackages", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "checkForErrors", "", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "js.frontend"})
public final class TopDownAnalyzerFacadeForJS {
    public static final TopDownAnalyzerFacadeForJS INSTANCE;

    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull JsConfig config) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        config.init();
        Project project = config.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"config.project");
        CompilerConfiguration compilerConfiguration = config.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
        List<ModuleDescriptorImpl> list2 = config.getModuleDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"config.moduleDescriptors");
        List<ModuleDescriptorImpl> list3 = config.getFriendModuleDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"config.friendModuleDescriptors");
        return TopDownAnalyzerFacadeForJS.analyzeFiles$default(INSTANCE, files2, project, compilerConfiguration, list2, list3, false, null, 96, null);
    }

    @NotNull
    public final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Project project, @NotNull CompilerConfiguration configuration, @NotNull List<ModuleDescriptorImpl> moduleDescriptors, @NotNull List<ModuleDescriptorImpl> friendModuleDescriptors, boolean thisIsBuiltInsModule, @Nullable ModuleDescriptorImpl customBuiltInsModule) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(moduleDescriptors, (String)"moduleDescriptors");
        Intrinsics.checkParameterIsNotNull(friendModuleDescriptors, (String)"friendModuleDescriptors");
        boolean bl = !thisIsBuiltInsModule || customBuiltInsModule == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can't simultaneously use custom built-ins module and set current module as built-ins";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        KotlinBuiltIns builtIns2 = thisIsBuiltInsModule ? (KotlinBuiltIns)new DefaultBuiltIns(false) : (customBuiltInsModule != null ? customBuiltInsModule.getBuiltIns() : JsPlatformAnalyzerServices.INSTANCE.getBuiltIns());
        String string = configuration.get(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration[CommonConf\u2026rationKeys.MODULE_NAME]!!");
        String moduleName = string;
        ProjectContext projectContext = ContextKt.ProjectContext(project, "TopDownAnalyzer for JS");
        Name name = Name.special('<' + moduleName + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$moduleName>\")");
        MutableModuleContext context2 = ContextKt.ContextForNewModule(projectContext, name, builtIns2, null);
        boolean bl5 = false;
        List additionalPackages = new ArrayList();
        if (thisIsBuiltInsModule) {
            builtIns2.setBuiltInsModule(context2.getModule());
            Collection collection = additionalPackages;
            PackageFragmentProvider packageFragmentProvider = FunctionInterfaceFactoryKt.functionInterfacePackageFragmentProvider(context2.getStorageManager(), context2.getModule());
            boolean bl6 = false;
            collection.add(packageFragmentProvider);
        }
        Set dependencies2 = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.mutableSetOf((Object[])new ModuleDescriptorImpl[]{context2.getModule()}), (Iterable)moduleDescriptors), (Object)builtIns2.getBuiltInsModule());
        context2.getModule().setDependencies(CollectionsKt.toList((Iterable)dependencies2), CollectionsKt.toSet((Iterable)friendModuleDescriptors));
        ModuleKind moduleKind = configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)moduleKind), (String)"configuration.get(JSConf\u2026E_KIND, ModuleKind.PLAIN)");
        ModuleKind moduleKind2 = moduleKind;
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context2.getModule(), moduleKind2);
        return this.analyzeFilesWithGivenTrace(files2, trace, context2, configuration, additionalPackages);
    }

    public static /* synthetic */ JsAnalysisResult analyzeFiles$default(TopDownAnalyzerFacadeForJS topDownAnalyzerFacadeForJS, Collection collection, Project project, CompilerConfiguration compilerConfiguration, List list2, List list3, boolean bl, ModuleDescriptorImpl moduleDescriptorImpl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            moduleDescriptorImpl = null;
        }
        return topDownAnalyzerFacadeForJS.analyzeFiles(collection, project, compilerConfiguration, list2, list3, bl, moduleDescriptorImpl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull CompilerConfiguration configuration, @NotNull List<? extends PackageFragmentProvider> additionalPackages) {
        PackageFragmentProvider packageFragmentProvider;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)moduleContext, (String)"moduleContext");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(additionalPackages, (String)"additionalPackages");
        LookupTracker lookupTracker = configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER);
        if (lookupTracker == null) {
            lookupTracker = LookupTracker.DO_NOTHING.INSTANCE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)lookupTracker, (String)"configuration.get(Common\u2026 LookupTracker.DO_NOTHING");
        LookupTracker lookupTracker2 = lookupTracker;
        ExpectActualTracker expectActualTracker = configuration.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER);
        if (expectActualTracker == null) {
            expectActualTracker = ExpectActualTracker.DoNothing.INSTANCE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)expectActualTracker, (String)"configuration.get(Common\u2026ctActualTracker.DoNothing");
        ExpectActualTracker expectActualTracker2 = expectActualTracker;
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration);
        IncrementalDataProvider incrementalDataProvider = configuration.get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            Collection<byte[]> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IncrementalDataProvider incrementalDataProvider2 = incrementalDataProvider;
            boolean bl = false;
            boolean bl2 = false;
            IncrementalDataProvider incrementalData = incrementalDataProvider2;
            boolean bl3 = false;
            Iterable iterable = incrementalData.getCompiledPackageParts().values();
            byte[] byArray = incrementalData.getHeaderMetadata();
            boolean $i$f$map = false;
            void var20_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TranslationResultValue translationResultValue = (TranslationResultValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                byte[] byArray2 = it.getMetadata();
                collection.add(byArray2);
            }
            collection = (List)destination$iv$iv;
            int[] nArray = incrementalData.getMetadataVersion();
            JsMetadataVersion jsMetadataVersion = new JsMetadataVersion(Arrays.copyOf(nArray, nArray.length));
            List list2 = collection;
            byte[] byArray3 = byArray;
            PackagesWithHeaderMetadata metadata = new PackagesWithHeaderMetadata(byArray3, list2, jsMetadataVersion);
            packageFragmentProvider = KotlinJavascriptSerializationUtil.INSTANCE.readDescriptors(metadata, moduleContext.getStorageManager(), moduleContext.getModule(), new CompilerDeserializationConfiguration(languageVersionSettings), lookupTracker2);
        } else {
            packageFragmentProvider = null;
        }
        PackageFragmentProvider packageFragment = packageFragmentProvider;
        LazyTopDownAnalyzer analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2), languageVersionSettings, lookupTracker2, expectActualTracker2, CollectionsKt.plus((Collection)additionalPackages, (Iterable)CollectionsKt.listOfNotNull(packageFragment)));
        LazyTopDownAnalyzer.analyzeDeclarations$default(analyzerForJs, TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        return JsAnalysisResult.Companion.success(trace, moduleContext.getModule());
    }

    public static /* synthetic */ JsAnalysisResult analyzeFilesWithGivenTrace$default(TopDownAnalyzerFacadeForJS topDownAnalyzerFacadeForJS, Collection collection, BindingTrace bindingTrace, ModuleContext moduleContext, CompilerConfiguration compilerConfiguration, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return topDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(collection, bindingTrace, moduleContext, compilerConfiguration, list2);
    }

    @JvmStatic
    public static final void checkForErrors(@NotNull Collection<? extends KtFile> allFiles, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(allFiles, (String)"allFiles");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (KtFile ktFile : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(ktFile);
        }
    }

    private TopDownAnalyzerFacadeForJS() {
    }

    static {
        TopDownAnalyzerFacadeForJS topDownAnalyzerFacadeForJS;
        INSTANCE = topDownAnalyzerFacadeForJS = new TopDownAnalyzerFacadeForJS();
    }
}

