/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.annotation.Nullable;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.AbstractWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerServer;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerProtocol;

public class NoIsolationWorkerFactory
implements WorkerFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ServiceRegistry parent;
    private WorkerExecutor workerExecutor;
    private WorkerProtocol workerServer;

    public NoIsolationWorkerFactory(BuildOperationExecutor buildOperationExecutor, ServiceRegistry parent) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.parent = parent;
    }

    public void setWorkerExecutor(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        DefaultServiceRegistry serviceRegistry = new DefaultServiceRegistry(new ServiceRegistry[]{this.parent});
        serviceRegistry.add(WorkerExecutor.class, (Object)workerExecutor);
        this.workerServer = new DefaultWorkerServer((ServiceRegistry)serviceRegistry);
    }

    @Override
    public BuildOperationAwareWorker getWorker(DaemonForkOptions forkOptions) {
        final WorkerExecutor workerExecutor = this.workerExecutor;
        final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return new AbstractWorker(this.buildOperationExecutor){

            @Override
            public DefaultWorkResult execute(ActionExecutionSpec spec, BuildOperationRef parentBuildOperation) {
                return this.executeWrappedInBuildOperation(spec, parentBuildOperation, new AbstractWorker.Work(){

                    @Override
                    public DefaultWorkResult execute(final ActionExecutionSpec spec) {
                        DefaultWorkResult result;
                        try {
                            result = (DefaultWorkResult)ClassLoaderUtils.executeInClassloader((ClassLoader)contextClassLoader, (Factory)new Factory<DefaultWorkResult>(){

                                @Nullable
                                public DefaultWorkResult create() {
                                    return NoIsolationWorkerFactory.this.workerServer.execute(spec);
                                }
                            });
                        }
                        finally {
                            workerExecutor.await();
                        }
                        return result;
                    }
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.NONE;
    }
}

