/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.WorkerSharedGlobalScopeServices;
import org.gradle.internal.snapshot.impl.DefaultValueSnapshotter;
import org.gradle.internal.state.ManagedFactoryRegistry;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultActionExecutionSpecFactory;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.FlatClassLoaderStructure;
import org.gradle.workers.internal.FlatClassLoaderWorker;
import org.gradle.workers.internal.IsolatableSerializerRegistry;
import org.gradle.workers.internal.IsolatedClassloaderWorker;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonMessageSerializer;
import org.gradle.workers.internal.WorkerProtocol;

public class WorkerDaemonServer
implements WorkerProtocol {
    private final ServiceRegistry serviceRegistry;
    private Worker isolatedClassloaderWorker;

    @Inject
    public WorkerDaemonServer(ServiceRegistry parent, RequestArgumentSerializers argumentSerializers) {
        this.serviceRegistry = WorkerDaemonServer.createWorkerDaemonServices(parent);
        argumentSerializers.add(WorkerDaemonMessageSerializer.create());
    }

    static ServiceRegistry createWorkerDaemonServices(ServiceRegistry parent) {
        return ServiceRegistryBuilder.builder().parent(parent).provider((Object)new WorkerSharedGlobalScopeServices()).provider((Object)new WorkerDaemonServices()).build();
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        try {
            Worker worker = this.getIsolatedClassloaderWorker(spec.getClassLoaderStructure());
            return worker.execute(spec);
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    private Worker getIsolatedClassloaderWorker(ClassLoaderStructure classLoaderStructure) {
        if (this.isolatedClassloaderWorker == null) {
            this.isolatedClassloaderWorker = classLoaderStructure instanceof FlatClassLoaderStructure ? new FlatClassLoaderWorker(this.getClass().getClassLoader(), this.serviceRegistry) : new IsolatedClassloaderWorker(classLoaderStructure, this.getClass().getClassLoader(), this.serviceRegistry, true);
        }
        return this.isolatedClassloaderWorker;
    }

    public String toString() {
        return "WorkerDaemonServer{}";
    }

    private static class WorkerDaemonServices {
        private WorkerDaemonServices() {
        }

        IsolatableSerializerRegistry createIsolatableSerializerRegistry(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
            return new IsolatableSerializerRegistry(classLoaderHierarchyHasher, managedFactoryRegistry);
        }

        ActionExecutionSpecFactory createActionExecutionSpecFactory(IsolatableFactory isolatableFactory, IsolatableSerializerRegistry serializerRegistry, InstantiatorFactory instantiatorFactory) {
            return new DefaultActionExecutionSpecFactory(isolatableFactory, serializerRegistry, instantiatorFactory);
        }

        DefaultValueSnapshotter createValueSnapshotter(ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ManagedFactoryRegistry managedFactoryRegistry) {
            return new DefaultValueSnapshotter(classLoaderHierarchyHasher, managedFactoryRegistry);
        }

        ClassLoaderHierarchyHasher createClassLoaderHierarchyHasher() {
            return new ClassLoaderHierarchyHasher(){

                @Nullable
                public HashCode getClassLoaderHash(@Nonnull ClassLoader classLoader) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

