/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import gnu.trove.TIntStack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.TreeBackedLighterAST;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ILightStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILightStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.BooleanStack;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.LightStubBuilder");
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file2) {
        LighterAST tree;
        if (file2 == null) {
            LightStubBuilder.$$$reportNull$$$0(0);
        }
        if ((tree = FORCED_AST.get()) == null) {
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + file2 + ", " + fileType);
                return null;
            }
            if (!(file2 instanceof PsiFileImpl)) {
                LOG.error("Unexpected PsiFile instance: " + file2 + ", " + file2.getClass());
                return null;
            }
            if (((PsiFileImpl)file2).getElementTypeForStubBuilder() == null) {
                LOG.error("File is not of IStubFileElementType: " + file2);
                return null;
            }
            FileASTNode node = file2.getNode();
            tree = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        StubElement rootStub = this.createStubForFile(file2, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree) {
        if (file2 == null) {
            LightStubBuilder.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(2);
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = new PsiFileStubImpl<PsiFile>(file2);
        if (psiFileStubImpl == null) {
            LightStubBuilder.$$$reportNull$$$0(3);
        }
        return psiFileStubImpl;
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root2, @NotNull StubElement rootStub) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(4);
        }
        if (root2 == null) {
            LightStubBuilder.$$$reportNull$$$0(5);
        }
        if (rootStub == null) {
            LightStubBuilder.$$$reportNull$$$0(6);
        }
        Stack<LighterASTNode> parents2 = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent2 = null;
        LighterASTNode element = root2;
        List children2 = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element != null) {
            List kids;
            boolean hasStub;
            ProgressManager.checkCanceled();
            StubElement stub = LightStubBuilder.createStub(tree, element, parentStub);
            boolean bl = hasStub = stub != parentStub || parent2 == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            if (!(parent2 != null && this.skipNode(tree, parent2, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent2 != null) {
                    parents2.push(parent2);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children2);
                    parentStubs.push(parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent2 = element;
                immediateParentStubbed = hasStub;
                children2 = kids;
                childNumber = 0;
                element = children2.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent2, element)) continue;
            }
            while (children2 != null && ++childNumber < children2.size()) {
                element = (LighterASTNode)children2.get(childNumber);
                if (this.skipNode(tree, parent2, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents2.isEmpty()) {
                parent2 = (LighterASTNode)parents2.pop();
                childNumber = childNumbers.pop();
                children2 = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children2.size()) {
                    element = (LighterASTNode)children2.get(childNumber);
                    if (this.skipNode(tree, parent2, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    @NotNull
    private static StubElement createStub(@NotNull LighterAST tree, @NotNull LighterASTNode element, @NotNull StubElement parentStub) {
        IElementType elementType;
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(7);
        }
        if (element == null) {
            LightStubBuilder.$$$reportNull$$$0(8);
        }
        if (parentStub == null) {
            LightStubBuilder.$$$reportNull$$$0(9);
        }
        if ((elementType = element.getTokenType()) instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    Object StubT = lightElementType.createStub(tree, element, parentStub);
                    if (StubT == null) {
                        LightStubBuilder.$$$reportNull$$$0(10);
                    }
                    return StubT;
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            LightStubBuilder.$$$reportNull$$$0(11);
        }
        return stubElement;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(12);
        }
        if (parent2 == null) {
            LightStubBuilder.$$$reportNull$$$0(13);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(14);
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent2), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent2, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        if (parent2 == null) {
            LightStubBuilder.$$$reportNull$$$0(15);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(16);
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        if (tree == null) {
            LightStubBuilder.$$$reportNull$$$0(17);
        }
        if (parent2 == null) {
            LightStubBuilder.$$$reportNull$$$0(18);
        }
        if (node == null) {
            LightStubBuilder.$$$reportNull$$$0(19);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "skipNode";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "skipChildProcessingWhenBuildingStubs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

