/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.scripting.configuration.ScriptingConfigurationKeys;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.StandardScriptDefinition;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/JvmCliScriptEvaluationExtension;", "Lorg/jetbrains/kotlin/cli/common/extensions/ScriptEvaluationExtension;", "()V", "eval", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "isAccepted", "", "kotlin-scripting-compiler"})
public final class JvmCliScriptEvaluationExtension
implements ScriptEvaluationExtension {
    public boolean isAccepted(@NotNull CommonCompilerArguments arguments) {
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        return arguments instanceof K2JVMCompilerArguments && ((K2JVMCompilerArguments)arguments).getScript();
    }

    @NotNull
    public ExitCode eval(@NotNull CommonCompilerArguments arguments, @NotNull CompilerConfiguration configuration, @NotNull JavaCoreProjectEnvironment projectEnvironment) {
        KotlinCoreEnvironment coreEnvironment;
        block5: {
            MessageCollector messageCollector;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
                Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                Intrinsics.checkParameterIsNotNull((Object)projectEnvironment, (String)"projectEnvironment");
                Object object = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
                messageCollector = (MessageCollector)object;
                MockProject mockProject = projectEnvironment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)mockProject, (String)"projectEnvironment.project");
                ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance((Project)mockProject);
                if (scriptDefinitionProvider == null) {
                    MessageCollector.DefaultImpls.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)"Unable to process the script, scripting plugin is not configured", null, (int)4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                String sourcePath = (String)CollectionsKt.first((List)arguments.getFreeArgs());
                ContentRootsKt.addKotlinSourceRoot$default((CompilerConfiguration)configuration, (String)sourcePath, (boolean)false, (int)2, null);
                configuration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, (Object)true);
                coreEnvironment = KotlinCoreEnvironment.Companion.createForProduction(projectEnvironment, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
                File scriptFile = new File(sourcePath);
                if (scriptFile.isDirectory()) break block4;
                String string = scriptFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptFile.name");
                if (scriptDefinitionProvider.isScript(string)) break block5;
            }
            String extensionHint = Intrinsics.areEqual((Object)((List)configuration.get(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS())), (Object)CollectionsKt.listOf((Object)StandardScriptDefinition.INSTANCE)) ? " (.kts)" : "";
            MessageCollector.DefaultImpls.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)("Specify path to the script file" + extensionHint + " as the first argument"), null, (int)4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        List scriptArgs = arguments.getFreeArgs().subList(1, arguments.getFreeArgs().size());
        return KotlinToJVMBytecodeCompiler.INSTANCE.compileAndExecuteScript(coreEnvironment, scriptArgs);
    }
}

