/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationDependency;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformCompletion;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformingAsyncArtifactListener;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ConsumerProvidedResolvedVariant
implements ResolvedArtifactSet {
    private final ComponentIdentifier componentIdentifier;
    private final ResolvedArtifactSet delegate;
    private final AttributeContainerInternal attributes;
    private final Transformation transformation;
    private final ExtraExecutionGraphDependenciesResolverFactory resolverFactory;
    private final TransformationNodeRegistry transformationNodeRegistry;

    public ConsumerProvidedResolvedVariant(ComponentIdentifier componentIdentifier, ResolvedArtifactSet delegate, AttributeContainerInternal target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory, TransformationNodeRegistry transformationNodeRegistry) {
        this.componentIdentifier = componentIdentifier;
        this.delegate = delegate;
        this.attributes = target;
        this.transformation = transformation;
        this.resolverFactory = dependenciesResolverFactory;
        this.transformationNodeRegistry = transformationNodeRegistry;
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        ConcurrentMap artifactResults = Maps.newConcurrentMap();
        ConcurrentMap fileResults = Maps.newConcurrentMap();
        ResolvedArtifactSet.Completion result = this.delegate.startVisit(actions, new TransformingAsyncArtifactListener(this.transformation, listener, actions, artifactResults, fileResults, this.getDependenciesResolver(), this.transformationNodeRegistry));
        return new TransformCompletion(result, this.attributes, artifactResults, fileResults);
    }

    @Override
    public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor listener) {
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)new DefaultTransformationDependency(this.transformation, this.delegate, this.getDependenciesResolver()));
    }

    private ExecutionGraphDependenciesResolver getDependenciesResolver() {
        return this.resolverFactory.create(this.componentIdentifier);
    }
}

