/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.plugin.devel.PluginDeclaration;

public class GeneratePluginDescriptors
extends DefaultTask {
    private final ListProperty<PluginDeclaration> declarations;
    private final DirectoryProperty outputDirectory;

    public GeneratePluginDescriptors() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.declarations = objectFactory.listProperty(PluginDeclaration.class);
        this.outputDirectory = objectFactory.directoryProperty();
    }

    @Input
    public ListProperty<PluginDeclaration> getDeclarations() {
        return this.declarations;
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void generatePluginDescriptors() {
        File outputDir = ((Directory)this.outputDirectory.get()).getAsFile();
        this.clearOutputDirectory(outputDir);
        for (PluginDeclaration declaration : (List)this.getDeclarations().get()) {
            File descriptorFile = new File(outputDir, declaration.getId() + ".properties");
            Properties properties = new Properties();
            properties.setProperty("implementation-class", declaration.getImplementationClass());
            this.writePropertiesTo(properties, descriptorFile);
        }
    }

    private void clearOutputDirectory(File directoryToClear) {
        try {
            FileUtils.cleanDirectory((File)directoryToClear);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void writePropertiesTo(Properties properties, File descriptorFile) {
        try {
            PropertiesUtils.store((Properties)properties, (File)descriptorFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

