/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.CoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.CoreEncodingProjectManager;
import org.jetbrains.kotlin.com.intellij.core.CoreProjectScopeBuilder;
import org.jetbrains.kotlin.com.intellij.core.CorePsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.core.MockDocumentCommitProcessor;
import org.jetbrains.kotlin.com.intellij.mock.MockDumbService;
import org.jetbrains.kotlin.com.intellij.mock.MockFileIndexFacade;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.mock.MockResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiCachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiModificationTrackerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectScopeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesManagerImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject myProject;
    protected final MessageBus myMessageBus;

    public CoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment2) {
        if (parentDisposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        if (applicationEnvironment2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(1);
        }
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment2;
        this.myProject = this.createProject(this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        this.myMessageBus = this.myProject.getMessageBus();
        PsiModificationTrackerImpl modificationTracker2 = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker2);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveCache.class, new ResolveCache(this.myMessageBus));
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, this.myMessageBus, modificationTracker2);
        this.registerProjectComponent(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(SmartPointerManager.class, SmartPointerManagerImpl.class);
        this.registerProjectComponent(PsiDocumentManager.class, new CorePsiDocumentManager(this.myProject, this.myPsiManager, this.myMessageBus, new MockDocumentCommitProcessor()));
        this.myProject.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
        this.myProject.registerService(CoreEncodingProjectManager.class, CoreEncodingProjectManager.class);
    }

    @NotNull
    protected MockProject createProject(@NotNull PicoContainer parent2, @NotNull Disposable parentDisposable) {
        if (parent2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(3);
        }
        MockProject mockProject = new MockProject(parent2, parentDisposable);
        if (mockProject == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(4);
        }
        return mockProject;
    }

    @NotNull
    protected ProjectScopeBuilder createProjectScopeBuilder() {
        CoreProjectScopeBuilder coreProjectScopeBuilder = new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade);
        if (coreProjectScopeBuilder == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(5);
        }
        return coreProjectScopeBuilder;
    }

    protected void preregisterServices() {
    }

    @NotNull
    protected FileIndexFacade createFileIndexFacade() {
        MockFileIndexFacade mockFileIndexFacade = new MockFileIndexFacade(this.myProject);
        if (mockFileIndexFacade == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(6);
        }
        return mockFileIndexFacade;
    }

    @NotNull
    protected ResolveScopeManager createResolveScopeManager(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(7);
        }
        MockResolveScopeManager mockResolveScopeManager = new MockResolveScopeManager(psiManager.getProject());
        if (mockResolveScopeManager == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(8);
        }
        return mockResolveScopeManager;
    }

    public <T> void registerProjectExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass2) {
        if (extensionPointName == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(9);
        }
        if (aClass2 == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(10);
        }
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getArea(this.myProject), extensionPointName, aClass2);
    }

    public <T> void addProjectExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension) {
        if (name == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(11);
        }
        if (extension == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(12);
        }
        name.getPoint(this.myProject).registerExtension(extension, this.myParentDisposable);
    }

    public <T> void registerProjectComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        if (interfaceClass == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(13);
        }
        if (implementation == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(14);
        }
        CoreApplicationEnvironment.registerComponentInstance(this.myProject.getPicoContainer(), interfaceClass, implementation);
        if (implementation instanceof Disposable) {
            Disposer.register(this.myProject, (Disposable)implementation);
        }
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(15);
        }
        return disposable;
    }

    @NotNull
    public CoreApplicationEnvironment getEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.myEnvironment;
        if (coreApplicationEnvironment == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(16);
        }
        return coreApplicationEnvironment;
    }

    @NotNull
    public MockProject getProject() {
        MockProject mockProject = this.myProject;
        if (mockProject == null) {
            CoreProjectEnvironment.$$$reportNull$$$0(17);
        }
        return mockProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/core/CoreProjectEnvironment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/core/CoreProjectEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectScopeBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileIndexFacade";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveScopeManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDisposable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createResolveScopeManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectExtensionPoint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addProjectExtension";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

