/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class OverlappingOutputs {
    private final String propertyName;
    private final String overlappedFilePath;

    public OverlappingOutputs(String propertyName, String overlappedFilePath) {
        this.propertyName = propertyName;
        this.overlappedFilePath = overlappedFilePath;
    }

    public static Optional<OverlappingOutputs> detect(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        for (Map.Entry entry : current.entrySet()) {
            String propertyName = (String)entry.getKey();
            FileSystemSnapshot beforeExecution = (FileSystemSnapshot)entry.getValue();
            FileCollectionFingerprint afterPreviousExecution = OverlappingOutputs.getFingerprintAfterPreviousExecution(previous, propertyName);
            OverlappingOutputs overlappingOutputs = OverlappingOutputs.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            return Optional.of(overlappingOutputs);
        }
        return Optional.empty();
    }

    private static FileCollectionFingerprint getFingerprintAfterPreviousExecution(@Nullable ImmutableSortedMap<String, FileCollectionFingerprint> previous, String propertyName) {
        FileCollectionFingerprint afterPreviousExecution;
        if (previous != null && (afterPreviousExecution = (FileCollectionFingerprint)previous.get((Object)propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionFingerprint.EMPTY;
    }

    @Nullable
    private static OverlappingOutputs detect(String propertyName, FileCollectionFingerprint previous, FileSystemSnapshot before) {
        Map previousFingerprints = previous.getFingerprints();
        OverlappingOutputsDetectingVisitor outputsDetectingVisitor = new OverlappingOutputsDetectingVisitor(previousFingerprints);
        before.accept((FileSystemSnapshotVisitor)outputsDetectingVisitor);
        String overlappingPath = outputsDetectingVisitor.getOverlappingPath();
        return overlappingPath == null ? null : new OverlappingOutputs(propertyName, overlappingPath);
    }

    private static boolean changedSincePreviousExecution(HashCode contentHash, HashCode previousContentHash) {
        return !contentHash.equals((Object)previousContentHash);
    }

    private static boolean createdSincePreviousExecution(@Nullable HashCode previousContentHash) {
        return previousContentHash == null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getOverlappedFilePath() {
        return this.overlappedFilePath;
    }

    public String toString() {
        return String.format("output property '%s' with path '%s'", this.propertyName, this.overlappedFilePath);
    }

    private static class OverlappingOutputsDetectingVisitor
    implements FileSystemSnapshotVisitor {
        private final Map<String, FileSystemLocationFingerprint> previousFingerprints;
        private int treeDepth = 0;
        private String overlappingPath;

        public OverlappingOutputsDetectingVisitor(Map<String, FileSystemLocationFingerprint> previousFingerprints) {
            this.previousFingerprints = previousFingerprints;
        }

        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            ++this.treeDepth;
            if (this.overlappingPath == null) {
                this.overlappingPath = this.detectOverlappingPath((FileSystemLocationSnapshot)directorySnapshot);
            }
            return this.overlappingPath == null;
        }

        public void visitFile(FileSystemLocationSnapshot fileSnapshot) {
            if (this.overlappingPath == null) {
                this.overlappingPath = this.detectOverlappingPath(fileSnapshot);
            }
        }

        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            --this.treeDepth;
        }

        @Nullable
        private String detectOverlappingPath(FileSystemLocationSnapshot beforeSnapshot) {
            HashCode previousContentHash;
            String path = beforeSnapshot.getAbsolutePath();
            HashCode contentHash = beforeSnapshot.getHash();
            FileSystemLocationFingerprint previousFingerprint = this.previousFingerprints.get(path);
            HashCode hashCode = previousContentHash = previousFingerprint == null ? null : previousFingerprint.getNormalizedContentHash();
            if ((!this.isRoot() || beforeSnapshot.getType() != FileType.Missing) && (OverlappingOutputs.createdSincePreviousExecution(previousContentHash) || beforeSnapshot.getType() != previousFingerprint.getType() || beforeSnapshot.getType() == FileType.RegularFile && OverlappingOutputs.changedSincePreviousExecution(contentHash, previousContentHash))) {
                return path;
            }
            return null;
        }

        private boolean isRoot() {
            return this.treeDepth == 0;
        }

        @Nullable
        public String getOverlappingPath() {
            return this.overlappingPath;
        }
    }
}

