/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.CapabilityInternal;

public class ImmutableCapability
implements CapabilityInternal {
    private final String group;
    private final String name;
    private final String version;
    private final int hashCode;
    private final String cachedId;

    public ImmutableCapability(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.hashCode = this.computeHashcode(group, name, version);
        this.cachedId = group + ":" + name;
    }

    private int computeHashcode(String group, String name, String version) {
        int hash = ImmutableCapability.safeHash(version);
        hash = 31 * hash + name.hashCode();
        hash = 31 * hash + group.hashCode();
        return hash;
    }

    private static int safeHash(String o) {
        return o == null ? 0 : o.hashCode();
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        Capability that = (Capability)o;
        return Objects.equal((Object)this.group, (Object)that.getGroup()) && Objects.equal((Object)this.name, (Object)that.getName()) && Objects.equal((Object)this.version, (Object)that.getVersion());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "capability group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'';
    }

    @Override
    public String getCapabilityId() {
        return this.cachedId;
    }
}

