/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Lists;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.SerializedParametersActionExecutionSpec;
import org.gradle.workers.internal.WorkerFactory;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final Class<? extends Compiler<T>> delegateClass;
    private final Object[] delegateParameters;
    private final WorkerFactory workerFactory;

    public AbstractDaemonCompiler(Class<? extends Compiler<T>> delegateClass, Object[] delegateParameters, WorkerFactory workerFactory) {
        this.delegateClass = delegateClass;
        this.delegateParameters = delegateParameters;
        this.workerFactory = workerFactory;
    }

    public Class<? extends Compiler<T>> getDelegateClass() {
        return this.delegateClass;
    }

    public WorkResult execute(T spec) {
        DaemonForkOptions daemonForkOptions = this.toDaemonForkOptions(spec);
        BuildOperationAwareWorker worker = this.workerFactory.getWorker(daemonForkOptions);
        DefaultWorkResult result = worker.execute((ActionExecutionSpec)new SerializedParametersActionExecutionSpec(CompilerCallable.class, "compiler daemon", new Object[]{this.delegateClass, this.delegateParameters, spec}, daemonForkOptions.getClassLoaderStructure()));
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    protected abstract DaemonForkOptions toDaemonForkOptions(T var1);

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryInitialSize(), (String)right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryMaximumSize(), (String)right.getMemoryMaximumSize()));
        Set mergedJvmArgs = MergeOptionsUtil.normalized(left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(right.getJvmArgs()));
        merged.setJvmArgs(Lists.newArrayList((Iterable)mergedJvmArgs));
        return merged;
    }

    public static class CompilerCallable<T extends CompileSpec>
    implements Callable<WorkResult> {
        private final Class<? extends Compiler<T>> compilerClass;
        private final Object[] compilerParameters;
        private final T compileSpec;
        private final InstantiatorFactory instantiatorFactory;
        private final ServiceRegistry serviceRegistry;

        @Inject
        public CompilerCallable(Class<? extends Compiler<T>> compilerClass, Object[] compilerParameters, T compileSpec, InstantiatorFactory instantiatorFactory, ServiceRegistry serviceRegistry) {
            this.compilerClass = compilerClass;
            this.compilerParameters = compilerParameters;
            this.compileSpec = compileSpec;
            this.instantiatorFactory = instantiatorFactory;
            this.serviceRegistry = serviceRegistry;
        }

        @Override
        public WorkResult call() throws Exception {
            Instantiator instantiator = this.instantiatorFactory.inject((ServiceLookup)this.serviceRegistry);
            Compiler compiler = (Compiler)instantiator.newInstance(this.compilerClass, this.compilerParameters);
            return compiler.execute(this.compileSpec);
        }
    }
}

