/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;

public class BroadcastChangingOutputsStep<C extends Context, R extends Result>
implements Step<C, R> {
    private final OutputChangeListener outputChangeListener;
    private final Step<? super C, ? extends R> delegate;

    public BroadcastChangingOutputsStep(OutputChangeListener outputChangeListener, Step<? super C, ? extends R> delegate) {
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public R execute(C context) {
        UnitOfWork work = context.getWork();
        Optional<? extends Iterable<String>> changingOutputs = work.getChangingOutputs();
        changingOutputs.ifPresent(outputs -> this.outputChangeListener.beforeOutputChange((Iterable<String>)outputs));
        if (!changingOutputs.isPresent()) {
            this.outputChangeListener.beforeOutputChange();
        }
        return this.delegate.execute(context);
    }
}

