/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.ReusableAction;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.model.ComponentVariant;

public abstract class PlatformSupport {
    public static final Category REGULAR_PLATFORM = (Category)NamedObjectInstantiator.INSTANCE.named(Category.class, "platform");
    public static final Category ENFORCED_PLATFORM = (Category)NamedObjectInstantiator.INSTANCE.named(Category.class, "enforced-platform");

    public static boolean isTargettingPlatform(HasConfigurableAttributes<?> target) {
        Category category = (Category)target.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
        return REGULAR_PLATFORM.equals(category) || ENFORCED_PLATFORM.equals(category);
    }

    public static void configureSchema(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy componentTypeMatchingStrategy = attributesSchema.attribute(Category.CATEGORY_ATTRIBUTE);
        componentTypeMatchingStrategy.getDisambiguationRules().add(ComponentCategoryDisambiguationRule.class);
    }

    static <T> void addPlatformAttribute(HasConfigurableAttributes<T> dependency, final Category category) {
        dependency.attributes((Action)new Action<AttributeContainer>(){

            public void execute(AttributeContainer attributeContainer) {
                attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)category);
            }
        });
    }

    public static boolean hasForcedDependencies(ComponentVariant variant) {
        return Objects.equal((Object)variant.getAttributes().getAttribute(MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE), (Object)"enforced-platform");
    }

    public static class PreferRegularPlatform
    implements AttributeDisambiguationRule<Category> {
        private static final Set<Category> PLATFORM_TYPES = ImmutableSet.of((Object)REGULAR_PLATFORM, (Object)ENFORCED_PLATFORM);

        public void execute(MultipleCandidatesDetails<Category> details) {
            if (details.getCandidateValues().equals(PLATFORM_TYPES)) {
                details.closestMatch((Object)REGULAR_PLATFORM);
            }
        }
    }

    public static class ComponentCategoryDisambiguationRule
    implements AttributeDisambiguationRule<Category>,
    ReusableAction {
        public void execute(MultipleCandidatesDetails<Category> details) {
            Category consumerValue = (Category)details.getConsumerValue();
            Set candidateValues = details.getCandidateValues();
            if (consumerValue == null) {
                candidateValues.stream().filter(it -> it.getName().equals("library")).findFirst().ifPresent(it -> details.closestMatch(it));
            }
        }
    }
}

