/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.MacroLookup;

public class CollectingMacroLookup
implements MacroLookup {
    private final List<MacroSource> uncollected = new ArrayList<MacroSource>();
    private final IncludeDirectives includeDirectives;
    private Map<File, IncludeDirectives> visible;

    public CollectingMacroLookup(IncludeDirectives includeDirectives) {
        this.includeDirectives = includeDirectives;
    }

    public CollectingMacroLookup() {
        this(IncludeDirectives.EMPTY);
    }

    public void append(File file, IncludeDirectives includeDirectives) {
        if (!includeDirectives.hasMacros() && !includeDirectives.hasMacroFunctions()) {
            return;
        }
        if (this.visible == null) {
            this.visible = new LinkedHashMap<File, IncludeDirectives>();
            this.visible.put(file, includeDirectives);
        } else if (!this.visible.containsKey(file)) {
            this.visible.put(file, includeDirectives);
        }
    }

    public void append(MacroSource source) {
        this.uncollected.add(source);
    }

    @Override
    public Iterator<IncludeDirectives> iterator() {
        this.collectAll();
        UnmodifiableIterator initialDirectives = Iterators.singletonIterator((Object)this.includeDirectives);
        if (this.visible == null || this.visible.isEmpty()) {
            return initialDirectives;
        }
        return Iterators.concat((Iterator)initialDirectives, this.visible.values().iterator());
    }

    public void appendTo(CollectingMacroLookup lookup) {
        this.collectAll();
        if (this.visible != null) {
            for (Map.Entry<File, IncludeDirectives> entry : this.visible.entrySet()) {
                lookup.append(entry.getKey(), entry.getValue());
            }
        }
    }

    private void collectAll() {
        while (!this.uncollected.isEmpty()) {
            MacroSource source = this.uncollected.remove(0);
            source.collectInto(this);
        }
    }

    static interface MacroSource {
        public void collectInto(CollectingMacroLookup var1);
    }
}

