/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FailureCollector;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

@NonNullApi
public class DefaultExecutionPlan
implements ExecutionPlan {
    private final Set<TaskNode> entryTasks = new LinkedHashSet<TaskNode>();
    private final NodeMapping nodeMapping = new NodeMapping();
    private final List<Node> executionQueue = Lists.newLinkedList();
    private final Map<Project, ResourceLock> projectLocks = Maps.newHashMap();
    private final FailureCollector failureCollector = new FailureCollector();
    private final TaskNodeFactory taskNodeFactory;
    private final TaskDependencyResolver dependencyResolver;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private boolean continueOnFailure;
    private final Set<Node> runningNodes = Sets.newIdentityHashSet();
    private final Set<Node> filteredNodes = Sets.newIdentityHashSet();
    private final Map<Node, MutationInfo> mutations = Maps.newIdentityHashMap();
    private final Map<File, String> canonicalizedFileCache = Maps.newIdentityHashMap();
    private final Map<Pair<Node, Node>, Boolean> reachableCache = Maps.newHashMap();
    private final Set<Node> dependenciesCompleteCache = Sets.newHashSet();
    private final WorkerLeaseService workerLeaseService;
    private final GradleInternal gradle;
    private boolean buildCancelled;

    public DefaultExecutionPlan(WorkerLeaseService workerLeaseService, GradleInternal gradle, TaskNodeFactory taskNodeFactory, TaskDependencyResolver dependencyResolver) {
        this.workerLeaseService = workerLeaseService;
        this.gradle = gradle;
        this.taskNodeFactory = taskNodeFactory;
        this.dependencyResolver = dependencyResolver;
    }

    public String getDisplayName() {
        Path path = this.gradle.findIdentityPath();
        if (path == null) {
            return "gradle";
        }
        return path.toString();
    }

    @Override
    public TaskNode getNode(Task task) {
        return this.nodeMapping.get(task);
    }

    public void addEntryTasks(Collection<? extends Task> tasks) {
        final ArrayDeque<TaskNode> queue = new ArrayDeque<TaskNode>();
        LinkedHashSet nodesInUnknownState = Sets.newLinkedHashSet();
        ArrayList<? extends Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        for (Task task : sortedTasks) {
            TaskNode node = this.taskNodeFactory.getOrCreateNode(task);
            if (node.isMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy((Object)task)) {
                node.require();
            }
            this.entryTasks.add(node);
            queue.add(node);
        }
        final HashSet visiting = Sets.newHashSet();
        while (!queue.isEmpty()) {
            boolean filtered;
            Node node = (Node)queue.getFirst();
            if (node.getDependenciesProcessed()) {
                queue.removeFirst();
                continue;
            }
            boolean bl = filtered = !this.nodeSatisfiesTaskFilter(node);
            if (filtered) {
                queue.removeFirst();
                node.dependenciesProcessed();
                node.doNotRequire();
                this.filteredNodes.add(node);
                continue;
            }
            if (visiting.add(node)) {
                node.prepareForExecution();
                node.resolveDependencies(this.dependencyResolver, new Action<Node>(){

                    public void execute(Node targetNode) {
                        if (!visiting.contains(targetNode)) {
                            queue.addFirst(targetNode);
                        }
                    }
                });
                if (node.isRequired()) {
                    for (Node successor : node.getDependencySuccessors()) {
                        if (!this.nodeSatisfiesTaskFilter(successor)) continue;
                        successor.require();
                    }
                    continue;
                }
                nodesInUnknownState.add(node);
                continue;
            }
            queue.removeFirst();
            visiting.remove(node);
            node.dependenciesProcessed();
        }
        this.resolveNodesInUnknownState(nodesInUnknownState);
    }

    private boolean nodeSatisfiesTaskFilter(Node successor) {
        if (successor instanceof LocalTaskNode) {
            return this.filter.isSatisfiedBy((Object)((LocalTaskNode)successor).getTask());
        }
        return true;
    }

    private void resolveNodesInUnknownState(Set<Node> nodesInUnknownState) {
        ArrayList queue = Lists.newArrayList(nodesInUnknownState);
        HashSet visiting = Sets.newHashSet();
        block0: while (!queue.isEmpty()) {
            Node node = (Node)queue.get(0);
            if (node.isInKnownState()) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(node)) {
                for (Node hardPredecessor : node.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.add(0, hardPredecessor);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(node);
            node.mustNotRun();
            for (Node predecessor : node.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.isMustNotRun());
                if (!predecessor.isRequired()) continue;
                node.require();
                continue block0;
            }
        }
    }

    private void requireWithDependencies(Node node) {
        if (node.isMustNotRun() && this.nodeSatisfiesTaskFilter(node)) {
            node.require();
            for (Node dependency : node.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        ArrayList nodeQueue = Lists.newArrayList((Iterable)Iterables.transform(this.entryTasks, (Function)new Function<TaskNode, NodeInVisitingSegment>(){
            private int index;

            public NodeInVisitingSegment apply(TaskNode taskNode) {
                return new NodeInVisitingSegment(taskNode, this.index++);
            }
        }));
        int visitingSegmentCounter = nodeQueue.size();
        HashMultimap visitingNodes = HashMultimap.create();
        ArrayDeque<GraphEdge> walkedShouldRunAfterEdges = new ArrayDeque<GraphEdge>();
        ArrayDeque<Node> path = new ArrayDeque<Node>();
        HashMap planBeforeVisiting = Maps.newHashMap();
        while (!nodeQueue.isEmpty()) {
            NodeInVisitingSegment nodeInVisitingSegment = (NodeInVisitingSegment)nodeQueue.get(0);
            int currentSegment = nodeInVisitingSegment.visitingSegment;
            Node node = nodeInVisitingSegment.node;
            if (node.isIncludeInGraph() || this.nodeMapping.contains(node)) {
                nodeQueue.remove(0);
                visitingNodes.remove((Object)node, (Object)currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, node);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey((Object)node);
            visitingNodes.put((Object)node, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, node);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle((HashMultimap<Node, Integer>)visitingNodes, nodeInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, node);
                for (Node node2 : node.getAllSuccessorsInReverseOrder()) {
                    if (visitingNodes.containsEntry((Object)node2, (Object)currentSegment)) {
                        if (!walkedShouldRunAfterEdges.isEmpty()) {
                            GraphEdge toBeRemoved = (GraphEdge)walkedShouldRunAfterEdges.pop();
                            TaskNode sourceTask = (TaskNode)toBeRemoved.from;
                            TaskNode targetTask = (TaskNode)toBeRemoved.to;
                            sourceTask.removeShouldSuccessor(targetTask);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, (HashMultimap<Node, Integer>)visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle(node2, node);
                    }
                    nodeQueue.add(0, new NodeInVisitingSegment(node2, currentSegment));
                }
                path.push(node);
                continue;
            }
            nodeQueue.remove(0);
            this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, node);
            visitingNodes.remove((Object)node, (Object)currentSegment);
            path.pop();
            this.nodeMapping.add(node);
            MutationInfo mutations = this.getOrCreateMutationsOf(node);
            for (Node dependency : node.getDependencySuccessors()) {
                this.getOrCreateMutationsOf((Node)dependency).consumingNodes.add(node);
                mutations.producingNodes.add(dependency);
            }
            Project project = node.getProject();
            if (project != null) {
                this.projectLocks.put(project, this.getOrCreateProjectLock(project));
            }
            for (Node finalizer : node.getFinalizers()) {
                if (visitingNodes.containsKey((Object)finalizer)) continue;
                nodeQueue.add(this.finalizerTaskPosition(finalizer, nodeQueue), new NodeInVisitingSegment(finalizer, visitingSegmentCounter++));
            }
        }
        this.executionQueue.clear();
        Iterables.addAll(this.executionQueue, (Iterable)this.nodeMapping);
    }

    private MutationInfo getOrCreateMutationsOf(Node node) {
        MutationInfo mutations = this.mutations.get(node);
        if (mutations == null) {
            mutations = new MutationInfo(node);
            this.mutations.put(node, mutations);
        }
        return mutations;
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Deque<GraphEdge> walkedShouldRunAfterEdges, Node node) {
        GraphEdge edge = walkedShouldRunAfterEdges.peek();
        if (edge != null && edge.to.equals(node)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(Map<Node, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        int count = planBeforeVisiting.get(toBeRemoved.from);
        this.nodeMapping.retainFirst(count);
    }

    private void restoreQueue(List<NodeInVisitingSegment> nodeQueue, HashMultimap<Node, Integer> visitingNodes, GraphEdge toBeRemoved) {
        NodeInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.node)) {
            nextInQueue = nodeQueue.get(0);
            visitingNodes.remove((Object)nextInQueue.node, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.node)) continue;
            nodeQueue.remove(0);
        }
    }

    private void restorePath(Deque<Node> path, GraphEdge toBeRemoved) {
        Node removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(final HashMultimap<Node, Integer> visitingNodes, final NodeInVisitingSegment nodeWithVisitingSegment) {
        Node node = nodeWithVisitingSegment.node;
        if (!(node instanceof TaskNode)) {
            return;
        }
        Iterables.removeIf(((TaskNode)node).getShouldSuccessors(), (Predicate)new Predicate<Node>(){

            public boolean apply(Node input) {
                return visitingNodes.containsEntry((Object)input, (Object)nodeWithVisitingSegment.visitingSegment);
            }
        });
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(Map<Node, Integer> planBeforeVisiting, Node node) {
        if (node instanceof TaskNode && !((TaskNode)node).getShouldSuccessors().isEmpty()) {
            planBeforeVisiting.put(node, this.nodeMapping.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Deque<GraphEdge> walkedShouldRunAfterEdges, Deque<Node> path, Node node) {
        if (!(node instanceof TaskNode)) {
            return;
        }
        Node previous = path.peek();
        if (previous instanceof TaskNode && ((TaskNode)previous).getShouldSuccessors().contains(node)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(previous, node));
        }
    }

    private int finalizerTaskPosition(Node finalizer, final List<NodeInVisitingSegment> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        Set<Node> precedingTasks = this.getAllPrecedingNodes(finalizer);
        Set precedingTaskIndices = CollectionUtils.collect(precedingTasks, (Transformer)new Transformer<Integer, Node>(){

            public Integer transform(final Node dependsOnTask) {
                return Iterables.indexOf((Iterable)nodeQueue, (Predicate)new Predicate<NodeInVisitingSegment>(){

                    public boolean apply(NodeInVisitingSegment nodeInVisitingSegment) {
                        return nodeInVisitingSegment.node.equals(dependsOnTask);
                    }
                });
            }
        });
        return (Integer)Collections.max(precedingTaskIndices) + 1;
    }

    private Set<Node> getAllPrecedingNodes(Node finalizer) {
        HashSet precedingNodes = Sets.newHashSet();
        ArrayDeque<Node> candidateNodes = new ArrayDeque<Node>();
        Iterables.addAll(candidateNodes, finalizer.getAllSuccessors());
        while (!candidateNodes.isEmpty()) {
            Node precedingNode = (Node)candidateNodes.pop();
            if (!precedingNodes.add(precedingNode) || !(precedingNode instanceof TaskNode)) continue;
            candidateNodes.addAll(((TaskNode)precedingNode).getMustSuccessors());
            candidateNodes.addAll(((TaskNode)precedingNode).getFinalizingSuccessors());
        }
        return precedingNodes;
    }

    private void onOrderingCycle(Node successor, Node node) {
        CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((DirectedGraph)new DirectedGraph<Node, Void>(){

            public void getNodeValues(Node node, Collection<? super Void> values, Collection<? super Node> connectedNodes) {
                connectedNodes.addAll(node.getDependencySuccessors());
                if (node instanceof TaskNode) {
                    TaskNode taskNode = (TaskNode)node;
                    connectedNodes.addAll(taskNode.getMustSuccessors());
                    connectedNodes.addAll(taskNode.getFinalizingSuccessors());
                }
            }
        });
        graphWalker.add(this.entryTasks);
        List cycles = graphWalker.findCycles();
        if (cycles.isEmpty()) {
            throw new GradleException("Misdetected cycle between " + node + " and " + successor + ". Help us by reporting this to https://github.com/gradle/gradle/issues/2293");
        }
        final ArrayList firstCycle = new ArrayList((Collection)cycles.get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<Node> graphRenderer = new DirectedGraphRenderer<Node>(new GraphNodeRenderer<Node>(){

            @Override
            public void renderTo(Node node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text((Object)node);
            }
        }, new DirectedGraph<Node, Object>(){

            public void getNodeValues(Node node, Collection<? super Object> values, Collection<? super Node> connectedNodes) {
                for (Node dependency : firstCycle) {
                    if (!node.hasHardSuccessor(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((Node)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    public void clear() {
        this.taskNodeFactory.clear();
        this.dependencyResolver.clear();
        this.entryTasks.clear();
        this.nodeMapping.clear();
        this.executionQueue.clear();
        this.projectLocks.clear();
        this.failureCollector.clearFailures();
        this.mutations.clear();
        this.canonicalizedFileCache.clear();
        this.reachableCache.clear();
        this.dependenciesCompleteCache.clear();
        this.runningNodes.clear();
    }

    @Override
    public Set<Task> getTasks() {
        return this.nodeMapping.getTasks();
    }

    @Override
    public Set<Task> getFilteredTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node filteredNode : this.filteredNodes) {
            if (!(filteredNode instanceof LocalTaskNode)) continue;
            builder.add((Object)((LocalTaskNode)filteredNode).getTask());
        }
        return builder.build();
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    @Override
    @Nullable
    public Node selectNext(WorkerLeaseRegistry.WorkerLease workerLease, ResourceLockState resourceLockState) {
        if (this.allProjectsLocked()) {
            return null;
        }
        Iterator<Node> iterator = this.executionQueue.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (!node.isReady() || !this.allDependenciesComplete(node)) continue;
            MutationInfo mutations = this.getResolvedMutationInfo(node);
            if (!(this.tryLockProjectFor(node) && workerLease.tryLock() && this.canRunWithCurrentlyExecutedNodes(node, mutations))) {
                resourceLockState.releaseLocks();
                continue;
            }
            if (node.allDependenciesSuccessful()) {
                this.recordNodeStarted(node);
                node.startExecution();
            } else {
                node.skipExecution();
            }
            iterator.remove();
            return node;
        }
        return null;
    }

    private boolean tryLockProjectFor(Node node) {
        if (node.getProject() != null) {
            return this.getProjectLock(node.getProject()).tryLock();
        }
        return true;
    }

    private void unlockProjectFor(Node node) {
        if (node.getProject() != null) {
            this.getProjectLock(node.getProject()).unlock();
        }
    }

    private ResourceLock getProjectLock(Project project) {
        return this.projectLocks.get(project);
    }

    private MutationInfo getResolvedMutationInfo(Node node) {
        MutationInfo mutations = this.mutations.get(node);
        if (!mutations.resolved) {
            this.resolveMutations(mutations, node);
        }
        return mutations;
    }

    private void resolveMutations(final MutationInfo mutations, Node node) {
        if (node instanceof LocalTaskNode) {
            final LocalTaskNode taskNode = (LocalTaskNode)node;
            final TaskInternal task = taskNode.getTask();
            ProjectInternal project = (ProjectInternal)task.getProject();
            ServiceRegistry serviceRegistry = project.getServices();
            final FileResolver resolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            final FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)serviceRegistry.get(FileCollectionFactory.class);
            PropertyWalker propertyWalker = (PropertyWalker)serviceRegistry.get(PropertyWalker.class);
            try {
                TaskPropertyUtils.visitProperties(propertyWalker, task, new PropertyVisitor.Adapter(){

                    @Override
                    public void visitOutputFileProperty(final String propertyName, boolean optional, final PropertyValue value, final OutputFilePropertyType filePropertyType) {
                        DefaultExecutionPlan.this.withDeadlockHandling(taskNode, "an output", "output property '" + propertyName + "'", new Runnable(){

                            @Override
                            public void run() {
                                FileParameterUtils.resolveOutputFilePropertySpecs(task.toString(), propertyName, value, filePropertyType, fileCollectionFactory, new Consumer<OutputFilePropertySpec>(){

                                    @Override
                                    public void accept(OutputFilePropertySpec outputFilePropertySpec) {
                                        mutations.outputPaths.addAll((Collection<String>)DefaultExecutionPlan.canonicalizedPaths(DefaultExecutionPlan.this.canonicalizedFileCache, (Iterable)outputFilePropertySpec.getPropertyFiles()));
                                    }
                                });
                            }
                        });
                        mutations.hasOutputs = true;
                    }

                    @Override
                    public void visitLocalStateProperty(final Object value) {
                        DefaultExecutionPlan.this.withDeadlockHandling(taskNode, "a local state property", "local state properties", new Runnable(){

                            @Override
                            public void run() {
                                mutations.outputPaths.addAll((Collection<String>)DefaultExecutionPlan.canonicalizedPaths(DefaultExecutionPlan.this.canonicalizedFileCache, (Iterable)resolver.resolveFiles(new Object[]{value})));
                            }
                        });
                        mutations.hasLocalState = true;
                    }

                    @Override
                    public void visitDestroyableProperty(final Object value) {
                        DefaultExecutionPlan.this.withDeadlockHandling(taskNode, "a destroyable", "destroyables", new Runnable(){

                            @Override
                            public void run() {
                                mutations.destroyablePaths.addAll((Collection<String>)DefaultExecutionPlan.canonicalizedPaths(DefaultExecutionPlan.this.canonicalizedFileCache, (Iterable)resolver.resolveFiles(new Object[]{value})));
                            }
                        });
                    }

                    @Override
                    public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                        mutations.hasFileInputs = true;
                    }
                });
            }
            catch (Exception e) {
                throw new TaskExecutionException(task, e);
            }
            mutations.resolved = true;
            if (!mutations.destroyablePaths.isEmpty()) {
                if (mutations.hasOutputs) {
                    throw new IllegalStateException("Task " + taskNode + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
                }
                if (mutations.hasFileInputs) {
                    throw new IllegalStateException("Task " + taskNode + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
                }
                if (mutations.hasLocalState) {
                    throw new IllegalStateException("Task " + taskNode + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
                }
            }
        }
    }

    private void withDeadlockHandling(TaskNode task, String singular, String description, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(String.format("A deadlock was detected while resolving the %s for task '%s'. This can be caused, for instance, by %s property causing dependency resolution.", description, task, singular), e);
        }
    }

    private boolean allDependenciesComplete(Node node) {
        if (this.dependenciesCompleteCache.contains(node)) {
            return true;
        }
        boolean dependenciesComplete = node.allDependenciesComplete();
        if (dependenciesComplete) {
            this.dependenciesCompleteCache.add(node);
        }
        return dependenciesComplete;
    }

    private boolean allProjectsLocked() {
        for (ResourceLock lock : this.projectLocks.values()) {
            if (lock.isLocked()) continue;
            return false;
        }
        return true;
    }

    private ResourceLock getOrCreateProjectLock(Project project) {
        Path buildPath = ((ProjectInternal)project).getMutationState().getOwner().getIdentityPath();
        Path projectPath = ((ProjectInternal)project).getIdentityPath();
        return this.workerLeaseService.getProjectLock(buildPath, projectPath);
    }

    private boolean canRunWithCurrentlyExecutedNodes(Node node, MutationInfo mutations) {
        Set<String> candidateNodeDestroyables = mutations.destroyablePaths;
        if (!this.runningNodes.isEmpty()) {
            Set<String> candidateMutations;
            Set<String> candidateNodeOutputs = mutations.outputPaths;
            Set<String> set = candidateMutations = !candidateNodeOutputs.isEmpty() ? candidateNodeOutputs : candidateNodeDestroyables;
            if (this.hasNodeWithOverlappingMutations(candidateMutations)) {
                return false;
            }
        }
        return !this.doesDestroyNotYetConsumedOutputOfAnotherNode(node, candidateNodeDestroyables);
    }

    private static ImmutableSet<String> canonicalizedPaths(Map<File, String> cache, Iterable<File> files) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File file : files) {
            builder.add((Object)DefaultExecutionPlan.canonicalizePath(file, cache));
        }
        return builder.build();
    }

    private static String canonicalizePath(File file, Map<File, String> cache) {
        try {
            String path = cache.get(file);
            if (path == null) {
                path = file.getCanonicalPath();
                cache.put(file, path);
            }
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private boolean hasNodeWithOverlappingMutations(Set<String> candidateMutationPaths) {
        if (!candidateMutationPaths.isEmpty()) {
            for (Node runningNode : this.runningNodes) {
                MutationInfo runningMutations = this.mutations.get(runningNode);
                Iterable runningMutationPaths = Iterables.concat(runningMutations.outputPaths, runningMutations.destroyablePaths);
                if (!DefaultExecutionPlan.hasOverlap(candidateMutationPaths, runningMutationPaths)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesDestroyNotYetConsumedOutputOfAnotherNode(Node destroyer, Set<String> destroyablePaths) {
        if (!destroyablePaths.isEmpty()) {
            for (MutationInfo producingNode : this.mutations.values()) {
                if (!producingNode.node.isComplete() || producingNode.consumingNodes.isEmpty() || !DefaultExecutionPlan.hasOverlap(destroyablePaths, producingNode.outputPaths)) continue;
                for (Node consumer : producingNode.consumingNodes) {
                    if (this.doesConsumerDependOnDestroyer(consumer, destroyer)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean doesConsumerDependOnDestroyer(Node consumer, Node destroyer) {
        if (consumer == destroyer) {
            return true;
        }
        Pair nodePair = Pair.of((Object)consumer, (Object)destroyer);
        if (this.reachableCache.get(nodePair) != null) {
            return this.reachableCache.get(nodePair);
        }
        boolean reachable = false;
        for (Node dependency : consumer.getAllSuccessors()) {
            if (dependency.isComplete() || !this.doesConsumerDependOnDestroyer(dependency, destroyer)) continue;
            reachable = true;
        }
        this.reachableCache.put((Pair<Node, Node>)nodePair, reachable);
        return reachable;
    }

    private static boolean hasOverlap(Iterable<String> paths1, Iterable<String> paths2) {
        for (String path1 : paths1) {
            for (String path2 : paths2) {
                String overLappedPath = DefaultExecutionPlan.getOverLappedPath(path1, path2);
                if (overLappedPath == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getOverLappedPath(String firstPath, String secondPath) {
        boolean isOverlapping;
        String longer;
        String shorter;
        if (firstPath.equals(secondPath)) {
            return firstPath;
        }
        if (firstPath.length() == secondPath.length()) {
            return null;
        }
        if (firstPath.length() > secondPath.length()) {
            shorter = secondPath;
            longer = firstPath;
        } else {
            shorter = firstPath;
            longer = secondPath;
        }
        boolean bl = isOverlapping = longer.startsWith(shorter) && longer.charAt(shorter.length()) == File.separatorChar;
        if (isOverlapping) {
            return shorter;
        }
        return null;
    }

    private void recordNodeStarted(Node node) {
        this.runningNodes.add(node);
    }

    private void recordNodeCompleted(Node node) {
        this.runningNodes.remove(node);
        MutationInfo mutations = this.mutations.get(node);
        for (Node producer : mutations.producingNodes) {
            MutationInfo producerMutations = this.mutations.get(producer);
            if (!producerMutations.consumingNodes.remove(node) || !DefaultExecutionPlan.canRemoveMutation(producerMutations)) continue;
            this.mutations.remove(producer);
        }
        if (DefaultExecutionPlan.canRemoveMutation(mutations)) {
            this.mutations.remove(node);
        }
    }

    private static boolean canRemoveMutation(@Nullable MutationInfo mutations) {
        return mutations != null && mutations.node.isComplete() && mutations.consumingNodes.isEmpty();
    }

    @Override
    public void nodeComplete(Node node) {
        try {
            if (!node.isComplete()) {
                DefaultExecutionPlan.enforceFinalizers(node);
                if (node.isFailed()) {
                    this.handleFailure(node);
                }
                node.finishExecution();
                this.recordNodeCompleted(node);
            }
        }
        finally {
            this.unlockProjectFor(node);
        }
    }

    private static void enforceFinalizers(Node node) {
        for (Node finalizerNode : node.getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.isMustNotRun()) continue;
            DefaultExecutionPlan.enforceWithDependencies(finalizerNode, Sets.newHashSet());
        }
    }

    private static void enforceWithDependencies(Node nodeInfo, Set<Node> enforcedNodes) {
        ArrayDeque<Node> candidateNodes = new ArrayDeque<Node>();
        candidateNodes.add(nodeInfo);
        while (!candidateNodes.isEmpty()) {
            Node node = (Node)candidateNodes.pop();
            if (enforcedNodes.contains(node)) continue;
            enforcedNodes.add(node);
            candidateNodes.addAll(node.getDependencySuccessors());
            if (!node.isMustNotRun() && !node.isRequired()) continue;
            node.enforceRun();
        }
    }

    @Override
    public void abortAllAndFail(Throwable t) {
        this.abortExecution(true);
        this.failureCollector.addFailure(t);
    }

    private void handleFailure(Node node) {
        Throwable executionFailure = node.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failureCollector.addFailure(executionFailure);
            return;
        }
        try {
            if (!this.continueOnFailure) {
                node.rethrowNodeFailure();
            }
            this.failureCollector.addFailure(node.getNodeFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failureCollector.addFailure(e);
        }
    }

    private boolean abortExecution() {
        return this.abortExecution(false);
    }

    @Override
    public void cancelExecution() {
        this.buildCancelled = this.abortExecution() || this.buildCancelled;
    }

    private boolean abortExecution(boolean abortAll) {
        boolean aborted = false;
        for (Node node : this.nodeMapping) {
            if (node.isRequired()) {
                node.skipExecution();
                aborted = true;
            }
            if (!abortAll || !node.isReady()) continue;
            node.abortExecution();
            aborted = true;
        }
        return aborted;
    }

    @Override
    public void collectFailures(Collection<? super Throwable> failures) {
        List<Throwable> collectedFailures = this.failureCollector.getFailures();
        failures.addAll(collectedFailures);
        if (this.buildCancelled && collectedFailures.isEmpty()) {
            failures.add((Throwable)new BuildCancelledException());
        }
    }

    @Override
    public boolean allNodesComplete() {
        for (Node node : this.nodeMapping) {
            if (node.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNodesRemaining() {
        for (Node node : this.executionQueue) {
            if (node.isComplete()) continue;
            return true;
        }
        return !this.runningNodes.isEmpty();
    }

    @Override
    public int size() {
        return this.nodeMapping.getNumberOfPublicNodes();
    }

    private static class NodeMapping
    extends AbstractCollection<Node> {
        private final Map<Task, LocalTaskNode> taskMapping = Maps.newLinkedHashMap();
        private final Set<Node> nodes = Sets.newLinkedHashSet();

        private NodeMapping() {
        }

        @Override
        public boolean contains(Object o) {
            return this.nodes.contains(o);
        }

        @Override
        public boolean add(Node node) {
            if (!this.nodes.add(node)) {
                return false;
            }
            if (node instanceof LocalTaskNode) {
                LocalTaskNode taskNode = (LocalTaskNode)node;
                this.taskMapping.put(taskNode.getTask(), taskNode);
            }
            return true;
        }

        public TaskNode get(Task task) {
            TaskNode taskNode = this.taskMapping.get(task);
            if (taskNode == null) {
                throw new IllegalStateException("Task is not part of the execution plan, no dependency information is available.");
            }
            return taskNode;
        }

        public Set<Task> getTasks() {
            return this.taskMapping.keySet();
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodes.iterator();
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.taskMapping.clear();
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        public int getNumberOfPublicNodes() {
            int publicNodes = 0;
            for (Node node : this) {
                if (!node.isPublicNode()) continue;
                ++publicNodes;
            }
            return publicNodes;
        }

        public void retainFirst(int count) {
            Iterator<Node> executionPlanIterator = this.nodes.iterator();
            for (int i = 0; i < count; ++i) {
                executionPlanIterator.next();
            }
            while (executionPlanIterator.hasNext()) {
                Node removedNode = executionPlanIterator.next();
                executionPlanIterator.remove();
                if (!(removedNode instanceof LocalTaskNode)) continue;
                this.taskMapping.remove(((LocalTaskNode)removedNode).getTask());
            }
        }
    }

    private static class MutationInfo {
        final Node node;
        final Set<Node> consumingNodes = Sets.newHashSet();
        final Set<Node> producingNodes = Sets.newHashSet();
        final Set<String> outputPaths = Sets.newHashSet();
        final Set<String> destroyablePaths = Sets.newHashSet();
        boolean hasFileInputs;
        boolean hasOutputs;
        boolean hasLocalState;
        boolean resolved;

        MutationInfo(Node node) {
            this.node = node;
        }
    }

    private static class NodeInVisitingSegment {
        private final Node node;
        private final int visitingSegment;

        private NodeInVisitingSegment(Node node, int visitingSegment) {
            this.node = node;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final Node from;
        private final Node to;

        private GraphEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }
    }
}

