/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.UserCodeAction;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyExtraInfoSpec;
import org.gradle.api.publish.ivy.IvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyExtraInfoSpec;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.reflect.Instantiator;

public class DefaultIvyModuleDescriptorSpec
implements IvyModuleDescriptorSpecInternal {
    private final MutableActionSet<XmlProvider> xmlActions = new MutableActionSet();
    private final IvyPublicationInternal ivyPublication;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private String status = "integration";
    private String branch;
    private IvyExtraInfoSpec extraInfo = new DefaultIvyExtraInfoSpec();
    private final List<IvyModuleDescriptorAuthor> authors = new ArrayList<IvyModuleDescriptorAuthor>();
    private final List<IvyModuleDescriptorLicense> licenses = new ArrayList<IvyModuleDescriptorLicense>();
    private IvyModuleDescriptorDescription description;

    public DefaultIvyModuleDescriptorSpec(IvyPublicationInternal ivyPublication, Instantiator instantiator, ObjectFactory objectFactory) {
        this.ivyPublication = ivyPublication;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public IvyExtraInfoSpec getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public void extraInfo(String namespace, String elementName, String value) {
        if (elementName == null) {
            throw new InvalidUserDataException("Cannot add an extra info element with null element name");
        }
        if (namespace == null) {
            throw new InvalidUserDataException("Cannot add an extra info element with null namespace");
        }
        this.extraInfo.add(namespace, elementName, value);
    }

    @Override
    public IvyPublicationIdentity getProjectIdentity() {
        return this.ivyPublication.getIdentity();
    }

    @Override
    public void withXml(Action<? super XmlProvider> action) {
        this.xmlActions.add((Action)new UserCodeAction("Could not apply withXml() to Ivy module descriptor", action));
    }

    @Override
    public Action<XmlProvider> getXmlAction() {
        return this.xmlActions;
    }

    @Override
    public Set<IvyConfiguration> getConfigurations() {
        return this.ivyPublication.getConfigurations();
    }

    @Override
    public Set<IvyArtifact> getArtifacts() {
        return this.ivyPublication.getArtifacts();
    }

    @Override
    public Set<IvyDependencyInternal> getDependencies() {
        return this.ivyPublication.getDependencies();
    }

    @Override
    public Set<IvyExcludeRule> getGlobalExcludes() {
        return this.ivyPublication.getGlobalExcludes();
    }

    @Override
    public void license(Action<? super IvyModuleDescriptorLicense> action) {
        this.configureAndAdd(DefaultIvyModuleDescriptorLicense.class, action, this.licenses);
    }

    @Override
    public List<IvyModuleDescriptorLicense> getLicenses() {
        return this.licenses;
    }

    @Override
    public void author(Action<? super IvyModuleDescriptorAuthor> action) {
        this.configureAndAdd(DefaultIvyModuleDescriptorAuthor.class, action, this.authors);
    }

    @Override
    public List<IvyModuleDescriptorAuthor> getAuthors() {
        return this.authors;
    }

    @Override
    public void description(Action<? super IvyModuleDescriptorDescription> action) {
        if (this.description == null) {
            this.description = (IvyModuleDescriptorDescription)this.instantiator.newInstance(DefaultIvyModuleDescriptorDescription.class, new Object[]{this.objectFactory});
        }
        action.execute((Object)this.description);
    }

    @Override
    public IvyModuleDescriptorDescription getDescription() {
        return this.description;
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.ivyPublication.writeGradleMetadataMarker();
    }

    private <T> void configureAndAdd(Class<? extends T> clazz, Action<? super T> action, List<T> items) {
        Object item = this.instantiator.newInstance(clazz, new Object[]{this.objectFactory});
        action.execute(item);
        items.add(item);
    }
}

