/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import javax.annotation.Nullable;
import org.gradle.internal.execution.ExecutionOutcome;

public enum TaskExecutionOutcome {
    FROM_CACHE(true, true, "FROM-CACHE"),
    UP_TO_DATE(true, true, "UP-TO-DATE"),
    SKIPPED(true, false, "SKIPPED"),
    NO_SOURCE(true, false, "NO-SOURCE"),
    EXECUTED(false, false, null);

    private final boolean skipped;
    private final boolean upToDate;
    private final String message;

    private TaskExecutionOutcome(@Nullable boolean skipped, boolean upToDate, String message) {
        this.skipped = skipped;
        this.upToDate = upToDate;
        this.message = message;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public static TaskExecutionOutcome valueOf(ExecutionOutcome outcome) {
        switch (outcome) {
            case FROM_CACHE: {
                return FROM_CACHE;
            }
            case UP_TO_DATE: {
                return UP_TO_DATE;
            }
            case EXECUTED: {
                return EXECUTED;
            }
        }
        throw new AssertionError();
    }
}

